using System;
using UnityEngine;
using UnityEngine.UI;
using DG.Tweening;
public class UIBtnSquish : MonoBehaviour
{
    // Start is called once before the first execution of Update after the MonoBehaviour is created
    public float squishScale = 0.8f; // Scale factor for squish effect
    public float duration = 0.2f;   // Duration of the squish effect

    private Button button;
    private Vector3 originalScale;

    void Start()
    {
       
    }

    private void Awake()
    {
        button = GetComponent<Button>();
        if (button == null)
        {
            Debug.LogError("ButtonSquish script must be attached to a UI Button.");
            return;
        }

        originalScale = transform.localScale;

        // Add a listener to the button's onClick event
        button.onClick.AddListener(OnButtonClicked);
    }

    void OnButtonClicked()
    {
        // Squish animation
        transform.DOScale(originalScale * squishScale, duration / 2)
            .SetEase(Ease.OutQuad)
            .OnComplete(() =>
            {
                // Return to original scale
                transform.DOScale(originalScale, duration / 2).SetEase(Ease.OutBounce);
            });
    }

    void OnDestroy()
    {
        // Remove the listener when the object is destroyed
        if (button != null)
        {
            button.onClick.RemoveListener(OnButtonClicked);
        }
    }
}
