using DG.Tweening;
using Unity.Cinemachine;
using UnityEngine;

public class SmoothlyChangeValues : MonoBehaviour
{
    // Start is called once before the first execution of Update after the MonoBehaviour is created
    public float duration = 2f; // Duration of the animation
    public Ease easing = Ease.OutQuart;
    private CinemachineSplineDolly sp;// Easing function for smooth slowing at the end

    [Range(0, 1)]
    public float cameraPosition = 0; // This value represents the camera's position on the dolly cart

    void Start()
    {
        sp = GetComponent<CinemachineSplineDolly>();
        // Animate cameraPosition from 0 to 1 with the specified easing and duration
        DOTween.To(() => cameraPosition, x => cameraPosition = x, 1, duration)
            .SetEase(easing)
            .OnUpdate(() =>
            {
                // Update the camera's position here using the value of cameraPosition
                UpdateCameraPosition(cameraPosition);
            })
            .OnComplete(() =>
            {
                Debug.Log("Camera animation complete!");
            });
    }

    void UpdateCameraPosition(float position)
    {
        // Logic to update the camera position on the dolly cart using the position value
        // Example: Adjust the dolly cart system or camera transform
        sp.CameraPosition = position;
    }
}
