using UnityEngine;

public class OpenLinkOnClick : MonoBehaviour
{
    // Set this to the URL you want to open
    [SerializeField] private string url = "https://example.com";

    private void Update()
    {
        if (Input.GetMouseButtonDown(0)) // 0 is the left mouse button
        {
            Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);
            RaycastHit hit;

            if (Physics.Raycast(ray, out hit))
            {
                if (hit.transform == transform)
                {
                    Application.OpenURL(url);
                }
            }
        }
    }
}
