using UnityEngine;
using DG.Tweening;

public class CoinFloat : MonoBehaviour
{
    [Header("Floating Settings")]
    [Tooltip("Vertical float distance from current position")]
    public float floatHeight = 0.5f;

    [Tooltip("Duration to float up or down")]
    public float floatDuration = 1f;

    [Tooltip("Ease type of the float animation")]
    public Ease floatEase = Ease.InOutSine;

    [Tooltip("Should the coin rotate while floating?")]
    public bool enableRotation = true;

    [Tooltip("Rotation speed in degrees per second")]
    public float rotationSpeed = 45f;

    private Vector3 initialPosition;
    private Tween floatTween;

    void Start()
    {
        initialPosition = transform.position;

        // Create a looping float tween
        floatTween = transform.DOMoveY(initialPosition.y + floatHeight, floatDuration)
            .SetEase(floatEase)
            .SetLoops(-1, LoopType.Yoyo);
    }

    void Update()
    {
        if (enableRotation)
        {
            transform.Rotate(Vector3.up * rotationSpeed * Time.deltaTime, Space.World);
        }
    }

    void OnDisable()
    {
        floatTween?.Kill();
    }
}
