import { createApi, fetchBaseQuery } from '@reduxjs/toolkit/query/react'
export const UserSlice = createApi({
  reducerPath: 'api',
  baseQuery: fetchBaseQuery({
    baseUrl: 'http://localhost:9090/api/auth/',
  }),
  tagTypes: ['Users'],
  endpoints: (builder) => ({
    register: builder.mutation({
      query: (user) => ({
        url: 'register',
        method: 'POST',
        body: user,
      }),
      invalidatesTags: ['Users'], // ✅ يخلي الكاش يتحدث بعد الإضافة
    }),
  }),
})

export const { useRegisterMutation } = UserSlice
