import { useEffect, useState } from 'react'
import { ErrorMessage, Field, Formik, Form } from 'formik'
import * as Yup from 'yup'
// import { useNavigate } from 'react-router-dom'
import { useRegisterMutation } from '../store-api/slices/User-slice'
import { ToastContainer, toast } from 'react-toastify'
function Register({ setpage }) {
  const [showPassword, setShowPassord] = useState(false)
  const [screen, setscreen] = useState(false)
  const initialValues = {
    email: '',
    password: '',
    name: '',
    phone: '',
    parent_phone: '',
    parent_email: '',
  }
  const [adduser] = useRegisterMutation()
  const schema = Yup.object({
    email: Yup.string().email('ايميل غير صحيح').required('الايميل مطلوب'),
    password: Yup.string().required('كلمه المرور مطلوبه').min(6),
  })
  useEffect(() => {
    const handleResize = () => {
      const width = window.innerWidth

      setscreen(width < 950)
    }

    handleResize()

    window.addEventListener('resize', handleResize)
    return () => window.removeEventListener('resize', handleResize)
  }, [])
  const errorNotify = () => toast.error('Wrong password or email')
  const successNotify1 = () => toast.success('Register done')
  // const navigate = useNavigate()
  const handleRegister = (values) => {
    console.log('register_data => ', values)
    let user = {
      username: values.name,
      email: values.email,
      password: values.password,
    }
    adduser(user)
      .unwrap()
      .then((res) => {
        console.log('✅ Added successfully:', res)
        successNotify1()
        console.log('res=>', res)
        setTimeout(() => {
          // navigate('/login')
        }, 2000)
      })
      .catch((err) => {
        console.log('err=>', err)
        errorNotify()
      })
  }

  return (
    <div className="auth_text">
      {screen && (
        <div className="circle_parent_l">
          <div className="big_circle_l"></div>
        </div>
      )}
      <p className="welcome">
        اهلا بك فى مختبر شارع العلوم
        <img src="./smileY.jpg" alt="" />
      </p>{' '}
      {screen && <div className="circle_l circle_reg"></div>}
      <p>قم بانشاء حساب جديد لحفظ تقدمك </p>
      <div className="reg_button">
        <button onClick={() => setpage('reg')}> حساب جديد</button>
        <button onClick={() => setpage('reg')}>تسجيل الدخول</button>
      </div>
      <p>بيانات الطالب </p>
      <Formik
        initialValues={initialValues}
        validationSchema={schema}
        onSubmit={handleRegister}
      >
        {() => (
          <Form>
            <div>
              <label htmlFor="name"> الإسم كامل*</label>
              <div className="input">
                <i className="fa-solid fa-user"></i>
                <Field
                  type="text"
                  id="name"
                  name="name"
                  placeholder=" قم بادخال اسمك بالكامل "
                />
              </div>
            </div>
            <div>
              <label htmlFor="phone">رقم الهاتف</label>
              <div className="input">
                <i className="fa-solid fa-user"></i>
                <Field
                  type="text"
                  id="phone"
                  required
                  placeholder=" قم بادخال  رقم الهاتف "
                  name="phone"
                />
                <ErrorMessage name="email" component="div" className="error" />
              </div>
            </div>
            <div>
              <label htmlFor="mail">البريد الإلكتروني*</label>
              <div className="input" id="mail">
                <i className="fa-solid fa-envelope"></i>
                <Field
                  type="email"
                  placeholder="قم بادخال البريد الالكترونى"
                  name="email"
                />
              </div>
            </div>
            <div>
              <label htmlFor="pass">كلمة المرور*</label>
              <div className="password">
                <div>
                  <i className="fa-solid fa-lock"></i>
                  <Field
                    placeholder=" قم بادخال كلمه المرور "
                    name="password"
                  />
                </div>
                {showPassword ? (
                  <i
                    className="fa-solid fa-eye-slash"
                    onClick={() => setShowPassord(!showPassword)}
                  ></i>
                ) : (
                  <i
                    className="fa-solid fa-eye"
                    onClick={() => setShowPassord(!showPassword)}
                  ></i>
                )}
              </div>
            </div>
            <p className="parent_info">بيانات ولي الأمر</p>
            <div>
              <label htmlFor="parent_phone"></label>
              <div className="input">
                <i className="fa-solid fa-user"></i>
                <Field
                  type="text"
                  id="parent_phone"
                  required
                  placeholder=" قم بادخال  رقم الهاتف "
                  name="parent_phone"
                />
              </div>
            </div>
            <div>
              <label htmlFor="mail">البريد الإلكتروني*</label>
              <div className="input" id="mail">
                <i className="fa-solid fa-envelope"></i>
                <Field
                  type="email"
                  placeholder="قم بادخال البريد الالكترونى"
                  name="parent_email"
                  // autoComplete={true}
                />
              </div>
            </div>
            <div className="log_button">
              <button type="submit">انشاء حساب</button>
            </div>
          </Form>
        )}
      </Formik>
      <p className="diff_p">او عن طريق </p>
      <div className="diff_login">
        <a>
          <i className="fa-brands fa-google"></i>
          <p>التسجيل من خلال جوجل</p>
        </a>
        <a>
          <i className="fa-brands fa-apple"></i>
          <p>التسجيل من خلال ابل</p>
        </a>
      </div>
      <ToastContainer />
    </div>
  )
}
export default Register
