import { useEffect, useState } from 'react'

import './Auth.css'
import { useNavigate } from 'react-router-dom'
import * as Yup from 'yup'
import { toast, ToastContainer } from 'react-toastify'
import { ErrorMessage, Field, Formik, Form } from 'formik'
// import { Formik, Form, Field, ErrorMessage } from "formik";
function Login({ setpage }) {
  const notify = () => toast.error('Wrong password or email')
  const [screen, setscreen] = useState(false)
  // const [login_true, setLogiTrue] = useState(false)
  const initialValues = {
    email: '',
    password: '',
  }

  const schema = Yup.object({
    email: Yup.string().email('ايميل غير صحيح').required('الايميل مطلوب'),
    password: Yup.string().required('كلمه المرور مطلوبه').min(6),
  })
  useEffect(() => {
    const handleResize = () => {
      const width = window.innerWidth

      setscreen(width < 950)
    }

    handleResize()

    window.addEventListener('resize', handleResize)
    return () => window.removeEventListener('resize', handleResize)
  }, [])
  const [showPassword, setShowPassord] = useState(false)
  const navigate = useNavigate()
  const handleSubmit = (values) => {
    console.log(' values:', values)
    if (values.email === 'user@123.com' && values.password === '123456') {
      let id = 1
      localStorage.setItem('userId', id)
      navigate('/')
    } else {
      notify()
    }
  }
  return (
    <div className="auth_text">
      {screen && (
        <div className="circle_parent_l">
          <div className="big_circle_l"></div>
        </div>
      )}
      <p className="welcome">
        اهلا بك فى مختبر شارع العلوم
        <img src="./smile.jpg" alt="" />
      </p>
      <p>قم بتسجيل الدخول لتتابع تقدمك </p>
      {screen && <div className="circle_l"></div>}
      <div className="reg_button">
        <button onClick={() => setpage('reg')}> حساب جديد</button>
        <button onClick={() => setpage('reg')}>تسجيل الدخول</button>
      </div>
      <Formik
        initialValues={initialValues}
        validationSchema={schema}
        onSubmit={handleSubmit}
      >
        {() => (
          <Form>
            <div>
              <div className="input">
                <i className="fa-solid fa-envelope"></i>
                <Field
                  type="email"
                  placeholder="البريد الالكترونى"
                  name="email"
                />
              </div>
              <ErrorMessage name="email" component="div" className="error" />
            </div>
            <div>
              <div className="password">
                <div>
                  <i className="fa-solid fa-lock"></i>
                  <Field
                    placeholder="كلمه المرور "
                    type={!showPassword && 'password'}
                    name="password"
                  />
                </div>
                {showPassword ? (
                  <i
                    className="fa-solid fa-eye-slash"
                    onClick={() => setShowPassord(!showPassword)}
                  ></i>
                ) : (
                  <i
                    className="fa-solid fa-eye"
                    onClick={() => setShowPassord(!showPassword)}
                  ></i>
                )}
              </div>
              <ErrorMessage name="password" component="div" className="error" />
            </div>
            <div>
              <a className="forg_pass" onClick={() => setpage('forg_pass')}>
                هل نسيت كلمه المرور ؟
              </a>
            </div>
            <div className="log_button">
              <button type="submit">تسجيل الدخول</button>
            </div>
          </Form>
        )}
      </Formik>
      <p className="diff_p">او عن طريق </p>
      <div className="diff_login">
        <a>
          <i className="fa-brands fa-google"></i>
          <p>التسجيل من خلال جوجل</p>
        </a>
        <a>
          <i className="fa-brands fa-apple"></i>
          <p>التسجيل من خلال ابل</p>
        </a>
      </div>
      <ToastContainer />
    </div>
  )
}
export default Login
