import { useEffect, useState } from 'react'
import './HomePage.css'
import { Questions, Temp1, Temp2, Temp3 } from './data'
import Question from './Question'
// import 'Question'  from  './'
// import Question from './Question'
export default function HomePage() {
  const [active_button, set_active_button] = useState('temp2')
  const [package_txt, set_package_txt] = useState([])
  const [time_line, set_time_line] = useState(1)
  const [time_contenet, set_time_contenet] = useState([])
  let questions = Questions
  const temp1 = Temp1
  const temp2 = Temp2
  const temp3 = Temp3
  useEffect(() => {
    const temp =
      active_button === 'temp1'
        ? temp1
        : active_button === 'temp2'
          ? temp2
          : temp3
    set_package_txt(temp)
  }, [active_button])
  const subjs = [
    {
      img: '/defult.png',
      title: 'رياضيات',
    },
    {
      img: '/defult.png',
      title: 'فيزياء',
    },
    {
      img: '/defult.png',
      title: 'كيمياء',
    },
  ]
  const timelines = [
    [
      {
        title: 'الاسبوع الاول',
        videos: '14 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '14 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '14 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '14 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '14 فيديو',
      },
    ],
    [
      {
        title: 'الاسبوع الاول',
        videos: '15 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '15 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '15 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '15 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '15 فيديو',
      },
    ],
    [
      {
        title: 'الاسبوع الاول',
        videos: '16 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '16 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '16 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '16 فيديو',
      },
      {
        title: 'الاسبوع الاول',
        videos: '16 فيديو',
      },
    ],
  ]
  useEffect(() => {
    let x = parseInt(time_line)
    set_time_contenet(timelines[x])
  }, [time_line])
  return (
    <div className="home_page">
      <div className="hero">
        <div className="hero_img">
          <div className="img_parent">
            <img alt="" src="/hero_img.png" />
          </div>
        </div>
        <div className="hero_txt">
          <h3>إكتشف العلوم بطريقة ممتعة!</h3>
          <p>
            من المناهج التعليمية إلى المعامل الافتراضية والألعاب التعليمية،
            منصتنا بتوفر تجربة علمية متكاملة تساعد الطلاب على الفهم والتطبيق
            والاستمتاع بالتعلم.
          </p>
          <div className="start_button">
            <button>ابدأ رحلتك الأن</button>
            <p>
              <i className="fa-solid fa-circle-play"></i>
              <span>شاهد كيف يعمل</span>{' '}
            </p>
          </div>
        </div>
      </div>
      <div className="counter_w">
        <div className="bg_frame">
          <img alt="" src="/counter_img.png" />
        </div>
        <div className="counters">
          <div className="counter_1">
            <p>+50</p>
            <p>لعبة تعليمية</p>
            <p>
              لغاز، تحديات، وألعاب تفاعلية بتخليك تتعلم المفاهيم العلمية بشكل
              ممتع ومسلي
            </p>
            <img alt="" src="/magn.png" />
          </div>
          <div className="counter_2">
            <p>+10</p>
            <p> مختبر إفتراضي</p>
            <p>
              معامل افتراضية ثلاثية الأبعاد تحاكي الواقع… لتتعلم وتستكشف وتنفّذ
              التجارب بدون أدوات أو مخاطر
            </p>
          </div>
          <div className="counter_3">
            <p>+100</p>
            <p>فيديو تفاعلي</p>
            <p>
              ستحصل لأول مره علي تعليم تفاعلي حقيقي وليس من وراء الشاشه ولكن
              مهارات تقنيه حقيقية
            </p>
            <img alt="" src="/home_atom.png" />
          </div>
        </div>
      </div>
      <div className="mini_games">
        <div className="bg_frame">
          <img alt="" src="/bg_frame.png" />
        </div>
        <div className="vir_lab ">
          <div className="vir_lab_img">
            <div className="img_parent">
              <img alt="" src="/hero_img.png" />
            </div>
          </div>
          <div className="vir_lab_txt">
            <h3>العب... وتعلم في نفس الوقت!</h3>
            <p>
              حوّل المذاكرة لمغامرة مسلية. الألعاب التعليمية بتخليك تتحدى نفسك
              وأصحابك، وتتعلم الرياضيات والعلوم بطريقة ممتعة وسهلة.
            </p>
            <div className="start_button">
              <button>
                <span>إبدأ الآن </span>
                <i className="fa-solid fa-arrow-left"></i>
              </button>
            </div>
          </div>
        </div>
      </div>
      <div className="curriculum">
        <h3>اختر مادّتك وابدأ رحلة التعلّم</h3>
        <p>
          استمتع بمناهج متكاملة مصممة خصيصاً لصفك الدراسي، مع دروس تفاعلية
          وألعاب تعليمية ومعامل افتراضية تساعدك على الفهم والتطبيق.
        </p>
        <div className="subjects">
          {subjs.map((sub, index) => {
            return (
              <div
                onClick={() => set_time_line(index)}
                key={index}
                className={index === time_line ? 'active_subj subj' : 'subj'}
              >
                <img src={sub.img} alt="" />
                <p>{sub.title}</p>
              </div>
            )
          })}
        </div>
        <div className="time">
          {' '}
          <div className="time_img">
            <img src="/cup.png" alt="" />
          </div>
          <div className="time_line">
            {time_contenet &&
              time_contenet.map((t) => {
                return (
                  <div key={t.id}>
                    <span className="s_circle"></span>
                    <h3> {t.title}</h3>
                    <p>{t.videos}</p>
                  </div>
                )
              })}
          </div>
        </div>
      </div>
      <div className="vir_lab">
        <div className="vir_lab_img">
          <div className="img_parent">
            <img alt="" src="/hero_img.png" />
          </div>
        </div>
        <div className="vir_lab_txt">
          <h3>ادخل المعمل... من غير ما تخرج من بيتك!</h3>
          <p>
            المعامل الافتراضية بتخليك تعيش تجربة علمية حقيقية من غير أي مخاطر.
            جرّب التفاعلات الكيميائية، فهم قوانين الفيزياء، واستكشف الأحياء بشكل
            ممتع وتفاعلي.
          </p>
          <div className="start_button">
            <button>
              <span> إبدأ الاستكشاف </span>
              <i className="fa-solid fa-arrow-left"></i>
            </button>
          </div>
        </div>
      </div>
      <div className="why_us">
        <div className="bg_frame">
          <img alt="" src="/bg_frame.png" />
        </div>
        <div className="why_us_cont">
          <div className="why_us_intro">
            <h3>ليه مختبر شارع العلوم؟</h3>
            <p>العب.. جرّب.. اتعلم.. وعيّد من الأول!</p>
          </div>
          <div className="why_us_conatiner">
            <div className="left_container">
              <div>
                <img alt="" src="/package_img.png" />
                <div>
                  <h4>الميزة التالتة</h4>
                  <p>
                    أجواء مرحة وصحبة لذيذة ، هتتعلم وكأنك بتلعب مع أصحابك،كله
                    هزار وضحك ومعرفة.
                  </p>
                </div>
              </div>
              <div>
                <img alt="" src="/package_img.png" />
                <div>
                  <h4>تجارب افتراضية على أصولها </h4>
                  <p>مهارات تلزق في الدماغ تفكير نقدي + حلول ذكية + إبداع</p>
                </div>
              </div>
            </div>
            <div>
              <img alt="" src="/defult.png" />
            </div>
            <div className="right_container">
              <div>
                <img alt="" src="/package_img.png" />
                <div>
                  <h4>تجارب افتراضية على أصولها </h4>
                  <p>
                    جرّب الكيمياء والفيزياء من غير ما تقلق على المعمل.. كلك لمسة
                    وهتعيش جو العلم.
                  </p>
                </div>
              </div>
              <div>
                <img alt="" src="/package_img.png" />
                <div>
                  <h4>التعليم بقى لعبة </h4>
                  <p>
                    مفيش مذاكرة مملة.. كل حاجة عبارة عن levels وتحديات وانت
                    البطل.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="vir_lab city_build">
        <div className="vir_lab_img">
          <div className="img_parent">
            <img alt="" src="/hero_img.png" />
          </div>
        </div>
        <div className="vir_lab_txt">
          <h3>ابني مدينتك.. وسيطر على العالم!</h3>
          <p>
            في لعبتنا الافتراضية هتبقى الـ عمدة.. تبني شوارع، تزرع أشجار، تعمل
            مولات، وتخلي مدينتك أحلى مدينة في المجرة 🚀 ، كل قرار بتاخده بيغيّر
            شكل مدينتك.. يعني هتتعلم الإدارة والتخطيط من غير ما تحس!
          </p>
          <div className="start_button">
            <button>
              <span> ابدأ تبني دلوقتي </span>
              <i className="fa-solid fa-arrow-left"></i>
            </button>
          </div>
        </div>
      </div>
      <div className="vir_lab who_us">
        <div className="vir_lab_img">
          <div className="img_parent">
            <img alt="" src="/logo.png" />
          </div>
        </div>
        <div className="vir_lab_txt">
          <span className="who_text">من نحن؟</span>
          <h3>`شارع العلوم` حيث يتعلم الطلاب العلوم بطريقة ممتعة وتفاعلية</h3>
          <p>
            شارع العلوم هي منصة تعليمية متخصصة في تبسيط العلوم للطلاب من الصف
            الرابع حتى الصف السادس .. مهمتنا إننا نساعد كل طالب يفكر بطريقة
            الباحث ويستكشف المفاهيم العلمية من خلال معلم ذكي بالذكاء الاصطناعي،
            معامل افتراضية، وألعاب تعليمية تفاعلية.
          </p>
        </div>
      </div>
      <div className="mini_games contact">
        <div className="bg_frame">
          <img alt="" src="/bg_frame.png" />
        </div>
        <div className="vir_lab ">
          <div className="vir_lab_img">
            <div className="img_parent">
              <img alt="" src="/hero_img.png" />
            </div>
          </div>
          <div className="vir_lab_txt">
            <span className="who_text">تواصل معنا</span>

            <p>
              لو عندك أي سؤال أو محتاج مساعدة، فريقنا موجود دايمًا عشان يجاوبك.
              ما تترددش إنك تتواصل معانا.
            </p>
          </div>
        </div>
        <div className="start_button">
          <button>
            <span>راسلنا الآن </span> <i className="fa-solid fa-arrow-left"></i>
          </button>
        </div>
      </div>
      <div className="packages">
        <h4>اختر الخطة اللي تناسبك وتعلم على راحتك</h4>
        <div className="packages_type">
          <button
            className={active_button === 'temp1' ? 'active_button' : ''}
            onClick={() => set_active_button('temp1')}
          >
            باقة العام
          </button>
          <button
            className={active_button === 'temp2' ? 'active_button' : ''}
            onClick={() => set_active_button('temp2')}
          >
            الباقة الشهرية{' '}
          </button>
          <button
            className={active_button === 'temp3' ? 'active_button' : ''}
            onClick={() => set_active_button('temp3')}
          >
            باقة الترم
          </button>
        </div>
        <div className="package_content">
          <div className="pack_img">
            <img src="/defult.png" alt="" />
          </div>
          <div className="package_txt">
            {package_txt &&
              package_txt.map((p, index) => {
                return (
                  <div key={index}>
                    <img alt="" src={p.img} />
                    <div className="p_txt">
                      <h3>{p.title}</h3>
                      <p>{p.desc}</p>
                    </div>
                  </div>
                )
              })}
          </div>
        </div>
      </div>
      <div className="questions">
        <h3>الأسئلة الشائعة</h3>
        <div className="questions_container">
          <div className="questions_img">
            <img alt="" src="/questions_img.png" />
          </div>
          <div className="questions_content">
            {questions &&
              questions.map((que) => {
                return <Question que={que} key={que.id} />
              })}
          </div>
        </div>
      </div>
    </div>
  )
}
// export default HomePage
