import { NavLink } from 'react-router-dom'
import './Header.css'
import { useEffect, useState } from 'react'
function Header() {
  useEffect(() => {
    let x = localStorage.getItem('userId')
    if (x) {
      setUser(true)
    }
  }, [])
  const [user, setUser] = useState(false)
  const subjectId = 0
  return (
    <header>
      <div className="bg_frame">
        <img alt="" src="/headerFrame.png" />
      </div>
      <div className={user ? 'header_contain diff_grid' : 'header_contain'}>
        {user ? (
          <div className="user_icons">
            <NavLink to={'/profile'}>
              {' '}
              <i className="fa-regular fa-circle-user"></i>
            </NavLink>
            <NavLink>
              <i className="fa-solid fa-cart-arrow-down"></i>
            </NavLink>
          </div>
        ) : (
          <div className="login">
            <NavLink to={'/login'}> تسجيل الدخول </NavLink>
          </div>
        )}

        <div className="links">
          <NavLink
            to={'/'}
            className={({ isActive }) => (isActive ? 'active_link' : '')}
          >
            الصفحه الرئيسية
          </NavLink>
          <NavLink
            to={`/subjects/${subjectId}`}
            className={({ isActive }) => (isActive ? 'active_link' : '')}
          >
            المواد الدراسية
          </NavLink>
          <NavLink
            to={`/labs/${subjectId}`}
            className={({ isActive }) => (isActive ? 'active_link' : '')}
          >
            المختبرات
          </NavLink>
          <NavLink
            to={`/games/${subjectId}`}
            className={({ isActive }) => (isActive ? 'active_link' : '')}
          >
            الألعاب
          </NavLink>
          <NavLink
            to={'/build'}
            className={({ isActive }) => (isActive ? 'active_link' : '')}
          >
            بناء المدينة
          </NavLink>
          <NavLink
            to={'/contact'}
            className={({ isActive }) => (isActive ? 'active_link' : '')}
          >
            تواصل معنا
          </NavLink>
        </div>
        <div className="logo">
          <NavLink to={'/'}>
            <img alt="" src="/logo.png" />
          </NavLink>
        </div>
      </div>
    </header>
  )
}
export default Header
