import { useEffect, useState } from 'react'
import Forget_pass from './Forget_pass'
import Login from './Login'
import NewPass from './NewPass'
import Register from './Register'

function Auth() {
  const [page, setPage] = useState('login')
  const setpage = (pageName) => {
    setPage(pageName)
  }
  const [screen, setscreen] = useState(false)
  useEffect(() => {
    const handleResize = () => {
      const width = window.innerWidth

      setscreen(width < 950)
    }

    handleResize()

    window.addEventListener('resize', handleResize)
    return () => window.removeEventListener('resize', handleResize)
  }, [])
  return (
    <div className="auth_page">
      {!screen && <img src="./background.jpg" alt="" className="background" />}
      {!screen && <img src="./hall.png" alt="" className="hall" />}

      <div className="auth">
        {!screen && (
          <div className="auth_img">
            <img src="./authimg.png" alt="" />
          </div>
        )}
        {page === 'login' ? (
          <Login setpage={setpage} />
        ) : page === 'reg' ? (
          <Register setpage={setpage} />
        ) : page === 'forg_pass' ? (
          <Forget_pass setpage={setpage} />
        ) : (
          <NewPass />
        )}
      </div>
    </div>
  )
}
export default Auth
