import 'swiper/css'
import 'swiper/css/grid'
import 'swiper/css/pagination'
import './subjects.css'
import { useRef, useState } from 'react'
import { Pagination } from 'swiper/modules'
// import Swiper from 'swiper'
import Lesson from './Lesson'
import { SwiperSlide, Swiper } from 'swiper/react'
import Lab from './Lab'
import Game from './Game'
function GridSwiper(props) {
  // lessons.js
  const lessons = props.data
  // console.log("lessos",lessons)
  const swiperRef = useRef(null)
  // const subject_name = 'العلوم'
  const rows = 3,
    cols = 3
  const pageSize = rows * cols
  const [end, setEnd] = useState(false)
  const [start, setStart] = useState(false)
  function chunk(arr, size) {
    const out = []
    for (let i = 0; i < arr.length; i += size) out.push(arr.slice(i, i + size))
    return out
  }
  const pages = chunk(lessons, pageSize)

  const [currentPage, setCurrentPage] = useState(0)
  const totalPages = pages.length

  const goToPage = (i) => {
    swiperRef.current?.slideTo(i)
    setCurrentPage(i)
  }

  const getPaginationRange = () => {
    const x = 1
    const range = []
    for (
      let i = Math.max(0, currentPage - x);
      i <= Math.min(totalPages - 1, currentPage + x);
      i++
    ) {
      range.push(i)
    }
    return range
  }

  const range = getPaginationRange()
  return (
    <div className="subjects_page">
      <p>
        <span>
          {props.type === 'lesson'
            ? 'المواد'
            : props.type === 'labs'
              ? 'المختبرات'
              : 'الالعاب'}
        </span>
        <span>{`>`}</span>
        <span>
          {!(props.type === 'lesson') && '  فى ماده '}
          {props.subj}
        </span>
      </p>
      <div className="lessons">
        <Swiper
          modules={[Pagination]}
          loop={false}
          onSwiper={(swiper) => {
            swiperRef.current = swiper

            setStart(swiper.isBeginning)
          }}
          onSlideChange={(swiper) => {
            setEnd(swiper.isEnd)
            setStart(swiper.isBeginning)
          }}
        >
          {pages.map((page, pageIndex) => (
            <SwiperSlide key={pageIndex}>
              <div
                style={{
                  display: 'grid',
                  gridTemplateColumns:
                    props.type === 'labs' ? 'repeat(4, 23%)' : 'repeat(3, 30%)',
                  //  gridTemplateRows: "repeat(2, 1fr)",
                  justifyContent: 'space-between',
                  rowGap: 36,
                  padding: 8,
                  height: 'fitcontent',
                }}
              >
                {page.map((item) =>
                  props.type === 'lesson' ? (
                    <Lesson lesson={item} key={item.id} />
                  ) : props.type === 'labs' ? (
                    <Lab lab={item} key={item.id} />
                  ) : (
                    <Game game={item} key={item.id} />
                  )
                )}
              </div>
            </SwiperSlide>
          ))}
        </Swiper>
        <div className="custom-nav-pag">
          <button
            className={start ? 'end_slider right' : 'right'}
            onClick={() => goToPage(currentPage - 1)}
            disabled={currentPage === 0}
          >
            <i className="fa-solid fa-angle-right"></i>
          </button>
          <div className="custom-pag">
            {currentPage > 1 && (
              <>
                <button onClick={() => goToPage(0)}>1</button>
                {currentPage > 2 && <span className="dots">…</span>}
              </>
            )}

            {range.map((i) => (
              <button
                key={i}
                onClick={() => goToPage(i)}
                className={currentPage === i ? 'active_pag' : ''}
              >
                {i + 1}
              </button>
            ))}

            {currentPage < totalPages - 2 && (
              <>
                {currentPage < totalPages - 3 && (
                  <span className="dots">…</span>
                )}
                <button onClick={() => goToPage(totalPages - 1)}>
                  {totalPages}
                </button>
              </>
            )}
          </div>

          <button
            onClick={() => goToPage(currentPage + 1)}
            disabled={currentPage === totalPages - 1}
            className={end ? 'end_slider left' : 'left'}
          >
            <i className="fa-solid fa-angle-left"></i>
          </button>
        </div>
      </div>
    </div>
  )
}
export default GridSwiper
