import { useState } from 'react'
import * as Yup from 'yup'
import './editprofile.css'
import { Field, Formik, Form } from 'formik'
function EditProfile() {
  const [fileImg, setFileImg] = useState(null)
  const [account, setAccount] = useState(true)
  const [imgname, setImgName] = useState('defult.png')
  const [showPass, setahowPass] = useState(false)
  const initialValues = {
    name: 'شهد أيمن مصطفى',
    gender: 'أنثى',
    bio: 'أعشق استكشاف المعرفة وتعلّم أشياء جديدة كل يوم. شغفي الأكبر هو أن أكون من الأوائل وأن أحقق إنجازات تخليني فخور بنفسي. أؤمن إن النجاح رحلة، وأنا بدأت رحلتي هنا مع المنصة عشان أبني مستقبلي بخطوة ورا خطوة.',
    class: 'الصف الرابع',
    email: 'shahdayman@gmail.com',
    phone: '1212763381',
    pass: '12345',
    P_email: 'ayman@gmail.com',
    P_phone: '1212121212',
  }
  const schema = Yup.object({
    name: Yup.string()
      .min(3, 'must be 3 charcters or more')
      .required('Name is required'),
    email: Yup.string()
      .email('Invalid email format')
      .required('Email is required'),
    pass: Yup.string().required('Paasword is required').min(6),
  })

  function handleimg(e) {
    setFileImg(e.target.files[0])
    setImgName(e.target.files[0].name)
    // console.log("e.target.files[0]=>",e.target.files[0])
  }
  const handleSubmit = (values) => {
    console.log(' values:', values)
    console.log(' fileImg:', fileImg)
    // alert("تم الحفظ!");
  }
  return (
    <div>
      <div className="editphoto">
        <img alt="" src="profile_wave.png" />
        <form>
          <div>
            <img alt="" src={imgname} />
            <label htmlFor="img">
              <i className="fa-solid fa-pen"></i>
            </label>
            <input
              type="file"
              id="img"
              accept=".jpg,.jpeg,.png"
              onChange={handleimg}
              placeholder=""
            />
          </div>
        </form>
      </div>
      <div className="change_opt">
        <button
          onClick={() => setAccount(false)}
          className={!account ? 'active_op' : ''}
        >
          طرق الدفع
        </button>
        <button
          onClick={() => setAccount(true)}
          className={account ? 'active_op' : ''}
        >
          بيانات الحساب
        </button>
      </div>

      <div className="account_edit">
        <Formik
          initialValues={initialValues}
          schema={schema}
          onSubmit={handleSubmit}
          enableReinitialize={true}
        >
          {() => (
            <Form>
              {
                account ? (
                  <>
                    <h3>بيانات الطالب</h3>
                    <div>
                      <div className="input_label">
                        <label htmlFor="name">الإسم كامل*</label>
                        <div className="input_icon">
                          <i className="fa-solid fa-user"></i>
                          <Field type="text" name="name" id="name" />
                        </div>
                      </div>
                      <div className="input_label">
                        <label htmlFor="gender">النوع*</label>
                        <div className="input_icon custom_select">
                          <i className="fa-solid fa-venus-mars"></i>
                          <Field as="select" name="gender" id="gender">
                            <option value="ذكر">ذكر</option>
                            <option value="أنثى">أنثى</option>
                            <i className="fa-solid fa-caret-up"></i>
                          </Field>
                        </div>
                      </div>
                    </div>

                    <div>
                      <div className="input_label">
                        <label htmlFor="name">البايو</label>
                        <Field as="textarea" name="bio" />
                      </div>
                      <div className="bio_info">
                        <div className="input_label">
                          <label htmlFor="class">الصف*</label>
                          <div className="input_icon custom_select">
                            <i className="fa-solid fa-user-graduate"></i>

                            <Field as="select" name="class" id="class">
                              <option value="الصف الاول">الصف الاول</option>
                              <option value=" الصف الثانى">الصف الثانى</option>
                              <option value="الصف الثالث">الصف الثالث</option>
                              <option value="الصف الرابع">الصف الرابع </option>
                              <option value="الصف الخامس">الصف الخامس</option>
                              <option value="الصف السادس">الصف السادس</option>
                              {/* <i className="fa-solid fa-caret-up"></i> */}
                            </Field>
                          </div>
                        </div>

                        <div className="input_label">
                          <label htmlFor="email">البريد الإلكتروني*</label>
                          <div className="input_icon">
                            <i className="fa-solid fa-envelope"></i>
                            <Field type="text" name="email" />
                          </div>
                        </div>
                      </div>
                    </div>

                    <div>
                      <div className="input_label">
                        <label htmlFor="phone">رقم الهاتف</label>
                        <div className="input_span">
                          <div className="input_icon">
                            <i className="fa-solid fa-phone-flip"></i>
                            <Field type="text" name="phone" id="phone" />
                          </div>
                          <span className="phone_span">+20 |</span>
                        </div>
                      </div>
                      <div className="input_label">
                        <label htmlFor="pass">كلمة المرور* </label>
                        <div className="input_span">
                          <div className="input_icon">
                            <i className="fa-solid fa-lock"></i>
                            <Field
                              id="pass"
                              type={showPass ? 'text' : 'password'}
                              name="pass"
                            />
                          </div>
                          <span className="pass_span">
                            {showPass ? (
                              <i
                                className="fa-solid fa-eye"
                                onClick={() => setahowPass(false)}
                              ></i>
                            ) : (
                              <i
                                className="fa-solid fa-eye-slash"
                                onClick={() => {
                                  setahowPass(true)
                                }}
                              ></i>
                            )}
                          </span>
                        </div>
                      </div>
                    </div>
                    <h3>بيانات ولي الأمر</h3>
                    <div>
                      <div className="input_label">
                        <label htmlFor="email">البريد الإلكتروني*</label>
                        <div className="input_icon">
                          <i className="fa-solid fa-envelope"></i>
                          <Field type="text" name="P_email" />
                        </div>
                      </div>
                      <div className="input_label">
                        <label htmlFor="phone">رقم الهاتف</label>
                        <div className="input_span">
                          <div className="input_icon">
                            <i className="fa-solid fa-phone-flip"></i>
                            <Field type="text" name="P_phone" />
                          </div>
                          <span className="phone_span">+20 |</span>
                        </div>
                      </div>
                    </div>
                  </>
                ) : (
                  <h3>إختر طريقة الدفع المناسبة لك</h3>
                )
                //     <div className='input_label payment'>

                //     <label htmlFor="payment">اختر طريقه الدفع المناسبه لك</label>
                // <div className='input_icon custom_select'>

                //                 <Field as='select' name='payment' id="payment">
                //                  <option value=" card">الدفع عن طريق الفيزا </option>
                //                  <option value=" fawry ">فورى </option>

                //                  </Field>
                // </div>
                // </div>
              }
              <div className="submit_cancel">
                <button type="submit">حفظ التعديلات</button>
                <button type="reset">إلغاء</button>
              </div>
            </Form>
          )}
        </Formik>
      </div>
    </div>
  )
}
export default EditProfile
