import { createApi, fetchBaseQuery } from '@reduxjs/toolkit/query/react'
export const UserSlice = createApi({
  reducerPath: 'api',
  baseQuery: fetchBaseQuery({
    baseUrl: 'https://68a4ba98c123272fb9b3a1cb.mockapi.io/apiadumark/',
  }),
  tagTypes: ['Users'],
  endpoints: (builder) => ({
    adduser: builder.mutation({
      query: (user) => ({
        url: 'Users',
        method: 'POST',
        body: user,
      }),
      invalidatesTags: ['Users'], // ✅ يخلي الكاش يتحدث بعد الإضافة
    }),
  }),
})

export const { useAdduserMutation } = UserSlice
