import './Profile.css'
import { useEffect, useRef, useState } from 'react'
import 'swiper/css' // core styles
import 'swiper/css/navigation' // if you want navigation
import 'swiper/css/pagination' // if you want pagination

import { Navigation } from 'swiper/modules'
import { profileGames, profileLabs, profileLessons } from './data'
import { NavLink } from 'react-router-dom'
// import Swiper from 'swiper'
import { SwiperSlide, Swiper } from 'swiper/react'
function Profile() {
  const s_score = 950,
    t_score = 1200
  const score = (parseInt(s_score) / parseInt(t_score)) * 100
  const medals = 3
  const [choose, set_choose] = useState('lessons')
  const [progData, setProgData] = useState([])
  const swiperRef = useRef(null)
  const [end, setEnd] = useState(false)
  const [start, setStart] = useState(false)
  //    const videoRefs = useRef([]);
  //   const [vidIndex, setVidIndex] = useState(null);
  const lessons = profileLessons
  const labs = profileLabs
  const games = profileGames
  const [screen, setscreen] = useState(false)
  const [Sscreen, setSscreen] = useState(false)
  useEffect(() => {
    const temp =
      choose === 'lessons' ? lessons : choose === 'labs' ? labs : games
    setProgData(temp)
  }, [choose])
  useEffect(() => {
    const handleResize = () => {
      const width = window.innerWidth

      setscreen(width < 426)
      setSscreen(width < 376)
    }

    handleResize()

    window.addEventListener('resize', handleResize)
    return () => window.removeEventListener('resize', handleResize)
  }, [])
  //        const handlePlay = () => {
  //     if (videoRefs.current[vidIndex]) {
  //       videoRefs.current[vidIndex].play();
  //     //   setIsPlaying(true);
  //     }
  //   };
  //   const handlePause = (index) => {
  //     if (vidIndex === index) {
  //       setVidIndex(null);
  //     }
  //   };
  return (
    <div>
      <div className="student_info">
        <div className="info">
          <div className="name_edit">
            <NavLink to={'/editprofile'}>
              <span>تعديل الملف الشخصى </span>
              <i className="fa-solid fa-pen"></i>
            </NavLink>
            <p>
              <span> شهد أيمن مصطفى</span>
              <span> | الصف الرابع </span>
            </p>
          </div>
          <p>
            أعشق استكشاف المعرفة وتعلّم أشياء جديدة كل يوم. شغفي الأكبر هو أن
            أكون من الأوائل وأن أحقق إنجازات تخليني فخور بنفسي. أؤمن إن النجاح
            رحلة، وأنا بدأت رحلتي هنا مع المنصة عشان أبني مستقبلي بخطوة ورا
            خطوة.
          </p>
        </div>
        <div className="student_img">
          <img src="./defult.png" alt="" />
        </div>
      </div>
      <div className="progress">
        <div className="crown">
          <i className="fa-solid fa-crown"></i>
          <span>{s_score} نقطة</span>
        </div>
        <div className="bar">
          <span style={{ width: `${score}%` }}></span>
        </div>
        <div className="crown">
          <i className="fa-solid fa-crown"></i>
          <span>{t_score} نقطة</span>
        </div>
      </div>
      <div className="achivements">
        <div className="days">
          <p>
            {' '}
            <i className="fa-solid fa-fire"></i>
            <span>20 يوم متواصل</span>
          </p>
          <p>شاهد إنجازاتك</p>
        </div>
        <div className="achivements_txt">
          <p>ذاكري 15 دقيقة يوميًا لتحافظي على الستريك وتحصلي على مكافآت</p>
          <p>
            <span className="grow">التقدم اليومي:</span>
            <span>12/15دقيقة •</span>
            <span>آخر زيارة:</span>
            <span>01/09/2025</span>
          </p>
          <p>
            <span className="grow">الميداليات:</span>
            {Array.from({ length: medals }).map((_, index) => (
              <i key={index} className="fa-solid fa-medal"></i>
            ))}
          </p>
        </div>
      </div>
      <div className="follow_prog">
        <h3>تابع تقدمك</h3>
        <div className="buttons">
          <button
            onClick={() => set_choose('lessons')}
            className={choose === 'lessons' ? 'active_choose' : ''}
          >
            الدروس
          </button>
          <button
            onClick={() => set_choose('labs')}
            className={choose === 'labs' ? 'active_choose' : ''}
          >
            المختبرات
          </button>
          <button
            onClick={() => set_choose('games')}
            className={choose === 'games' ? 'active_choose' : ''}
          >
            الألعاب
          </button>
        </div>
        <div className="prog_videos">
          <Swiper
            modules={[Navigation]}
            className="mySwiper"
            spaceBetween={50}
            slidesPerView={screen ? (Sscreen < 376 ? 1 : 2) : 3}
            onSwiper={(swiper) => {
              swiperRef.current = swiper

              setStart(swiper.isBeginning)
            }}
            onSlideChange={(swiper) => {
              setEnd(swiper.isEnd)
              setStart(swiper.isBeginning)
            }}
          >
            {progData
              ? progData.map((l, index) => {
                  return (
                    <SwiperSlide key={index}>
                      <div className="lesson">
                        {/* // <video src="./[arabseed].I.Am.Legend.2007.BluRay.480.mp4" /> */}
                        <div className="image">
                          {/* <video  onPlay={() => setVidIndex(index)}   
            onPause={() => handlePause(index)}  controls={(index===vidIndex)} className={(index===vidIndex)&&"show_vid"} ref={(el) => (videoRefs.current[index] = el)}>
  <source src="[arabseed].I.Am.Legend.2007.BluRay.480.mp4"/></video> */}
                          <div className="clock">
                            <span>{l.clock}</span>
                            <img src="./time-left.png" alt="" />
                          </div>
                          {/* {(index!==vidIndex)&& */}
                          <i
                            className="fa-solid fa-play" /* onClick={(()=>{handlePlay();setVidIndex(index)})}*/
                          ></i>
                          {/* } */}
                        </div>
                        <p className="less_title">
                          <span>الدرس الاول</span>
                          <span>{l.title}</span>
                        </p>
                        <div className="bar">
                          <span
                            style={{
                              width: `${(parseInt(l.stop_time) / parseInt(l.time)) * 100}%`,
                            }}
                          ></span>
                        </div>
                        <p className="time_prog">
                          {' '}
                          {l.stop_time}دقيقه من {l.time}
                        </p>
                      </div>
                    </SwiperSlide>
                  )
                })
              : null}
          </Swiper>
          <div className="custom-nav">
            <button
              className={start ? 'end_slider' : ''}
              onClick={() => swiperRef.current?.slidePrev()}
            >
              <i className="fa-solid fa-arrow-right"></i>
            </button>
            <button
              onClick={() => swiperRef.current?.slideNext()}
              className={end ? 'end_slider' : ''}
            >
              <i className="fa-solid fa-arrow-left"></i>
            </button>
          </div>
        </div>
      </div>
    </div>
  )
}
export default Profile
