import { useEffect, useRef, useState } from 'react'
import './Otp.css'

function Otpcode() {
  const [time, setTime] = useState(2 * 60 + 28)
  const [ind, setInd] = useState(0)
  const [code, setCode] = useState(new Array(6).fill(''))
  const inputRefs = useRef([])
  useEffect(() => {
    if (time < 0) return
    const timer = setInterval(() => {
      setTime((prev) => {
        if (prev <= 1) {
          // stop at 0
          clearInterval(timer)
          return 0
        }
        return prev - 1
      })
    }, 1000)
    //    console.log("timer=>",timer)
    return () => clearInterval(timer)
  }, time)
  const minutes = Math.floor(time / 60)
  const seconds = time % 60
  useEffect(() => {
    if (inputRefs.current[0]) {
      inputRefs.current[0].focus()
    }
  }, [])

  const handleBackKey = (e, index) => {
    if (e.key === 'Backspace' && !code[index] && index > 0) {
      inputRefs.current[index - 1].focus()
    }
  }

  function handleOtp(e, ind) {
    if (isNaN(e.target.value)) return false
    setCode([
      ...code.map((data, index) =>
        parseInt(ind) === parseInt(index) ? e.target.value : data
      ),
    ])
    setInd(ind + 1)

    if (e.target.value && inputRefs.current[ind + 1]) {
      inputRefs.current[ind + 1].focus()
    }
  }
  return (
    <div className="otp_page">
      <div className="atom_img">
        <img alt="" src="./atom.png" />
      </div>
      <div className="otp_info">
        <div>
          <img alt="" src="./defult.png" />
        </div>
        <h3>تأكيد الهوية</h3>
        <p>
          “تم إرسال رمز مكوّن من 6 أرقام إلى رقم هاتفك 01019155499 أدخل الرمز
          لإعادة تعيين كلمة المرور.”
        </p>
        {time > 0 && (
          <p className="timer">
            {' '}
            “الرمز ينتهي خلال {minutes}:{seconds} لا تشارك هذا الرمز مع أي شخص.”
          </p>
        )}
        <form className="otp_form">
          <div className="otpcode">
            {code.map((otp, index) => {
              return (
                <div
                  className={ind === index ? 'otpP bold_b' : 'otpP '}
                  key={index}
                >
                  <input
                    onKeyDown={(e) => handleBackKey(e, index)}
                    ref={(el) => (inputRefs.current[index] = el)}
                    className={ind === index ? 'otpN otb_b' : 'otpN '}
                    key={index}
                    onChange={(e) => handleOtp(e, index)}
                    type="text"
                    value={otp}
                    maxLength={1}
                  />
                </div>
              )
            })}
          </div>
          <div className="log_button otp_button">
            <button type="submit">تاكيد</button>
          </div>
        </form>
        <div className="rec_otp">
          <p className="en_text">
            {' '}
            <button>أعد الإرسال</button> ؟OTP لم تقم بإستلام رمز{' '}
          </p>
        </div>
      </div>
      <div className="circle_parent">
        <div className="big_circle"></div>
      </div>
    </div>
  )
}
export default Otpcode
