import { useNavigate } from 'react-router-dom'
function Lesson(props) {
  const navigate = useNavigate()
  function lesson_detail(id) {
    navigate(`/lessonDetail/${id}`)
  }
  return (
    <div className="s_lesson">
      <div className="image">
        <div className="clock">
          <span>{props.lesson.duration}</span>
          <img src="/time-left.png" alt="" />
        </div>
        <i className="fa-solid fa-play"></i>
      </div>
      <div className="lesson_info">
        <p className="less_title">
          <span>الدرس {props.lesson.number} : </span>
          <span>{props.lesson.title}</span>
        </p>
        <div className="tags">
          {props.lesson.tags.map((tag, index) => {
            return <span key={index}> {tag}</span>
          })}
        </div>
        <div className="watch_button">
          <button onClick={() => lesson_detail(props.lesson.id)}>
            مشاهده الدرس{' '}
          </button>
        </div>
      </div>
    </div>
  )
}
export default Lesson
