import './App.css'
import { Route, Routes, useLocation } from 'react-router-dom'
import Auth from './components/Auth'
import HomePage from './components/HomePage'
import Profile from './components/Profile'
import Header from './components/Header'
import Footer from './components/Footer'
import EditProfile from './components/EditProfile'
import Subjects from './components/Subjects'
import LessonDetails from './components/LessonDetails'
import Games from './components/Games'
import Labs from './components/Labs'

function App() {
  const location = useLocation()
  return (
    <div>
      {location.pathname === '/login' ||
      location.pathname === '/editprofile' ? null : (
        <Header />
      )}
      <Routes>
        <Route path="/" element={<HomePage />} />
        <Route path="/login" element={<Auth />} />
        <Route path="/profile" element={<Profile />} />
        <Route path="/editprofile" element={<EditProfile />} />
        <Route path="/subjects/:subjectId" element={<Subjects />} />
        <Route path="/games/:subjectId" element={<Games />} />
        <Route path="/labs/:subjectId" element={<Labs />} />
        <Route path="/lessonDetail/:lessonId" element={<LessonDetails />} />
      </Routes>
      {location.pathname === '/login' ? null : <Footer />}
    </div>
  )
}

export default App
