// import axios from "axios";

// const API_URL =
//   import.meta.env.VITE_API_URL ||
//   "https://scenario-api.caprover.al-arcade.com/api/";

// const api = axios.create({
//   baseURL: API_URL,
//   headers: {
//     "Content-Type": "application/json",
//   },
// });

// api.interceptors.request.use(
//   (config) => {
//     const token = localStorage.getItem("accessToken");
//     if (token) {
//       config.headers.Authorization = `Bearer ${token}`;
//     }
//     return config;
//   },

//   (error) => Promise.reject(error)
// );

// let isRefreshing = false;
// let failedQueue = [];

// const processQueue = (error, token = null) => {
//   failedQueue.forEach((prom) => {
//     if (error) {
//       prom.reject(error);
//     } else {
//       prom.resolve(token);
//     }
//   });
//   failedQueue = [];
// };

// api.interceptors.response.use(
//   (response) => response,
//   async (error) => {
//     const originalRequest = error.config;

//     if (
//       error.response?.status === 401 &&
//       (error.response?.data?.code === "TOKEN_EXPIRED" ||
//         error.response?.data?.code === " jwt expired") &&
//       !originalRequest._retry
//     ) {
//       if (isRefreshing) {
//         return new Promise((resolve, reject) => {
//           failedQueue.push({ resolve, reject });
//         })
//           .then((token) => {
//             originalRequest.headers.Authorization = `Bearer ${token}`;
//             return api(originalRequest);
//           })
//           .catch((err) => Promise.reject(err));
//       }

//       originalRequest._retry = true;
//       isRefreshing = true;

//       try {
//         const refreshToken = localStorage.getItem("refreshToken");
//         const response = await axios.post(`${API_URL}/auth/refresh-token`, {
//           refreshToken,
//         });

//         const { accessToken, refreshToken: newRefreshToken } =
//           response.data.data;

//         localStorage.setItem("accessToken", accessToken);
//         localStorage.setItem("refreshToken", newRefreshToken);

//         processQueue(null, accessToken);

//         originalRequest.headers.Authorization = `Bearer ${accessToken}`;
//         return api(originalRequest);
//       } catch (refreshError) {
//         if (originalRequest.url.includes("/scenarios")) {
//           console.log(
//             "Refresh failed, but continuing as guest for scenarios..."
//           );
//           localStorage.removeItem("accessToken");
//           localStorage.removeItem("refreshToken");

//           delete originalRequest.headers.Authorization;
//           return api(originalRequest);
//         }
//         processQueue(refreshError, null);
//         localStorage.removeItem("accessToken");
//         localStorage.removeItem("refreshToken");

//         window.dispatchEvent(new Event("force-logout"));
//         return Promise.reject(refreshError);
//       } finally {
//         isRefreshing = false;
//       }
//     }
//     return Promise.reject(error);
//   }
// );
// // Auth API
// export const authAPI = {
//   register: (data) => api.post("/auth/register", data),
//   login: (data) => api.post("/auth/login", data),
//   logout: () => {
//     const refreshToken = localStorage.getItem("refreshToken");
//     return api.post("/auth/logout", { refreshToken });
//   },
//   getProfile: () => api.get("/auth/profile"),
//   refreshToken: (refreshToken) =>
//     api.post("/auth/refresh-token", { refreshToken }),
// };

// // Scenarios API
// export const scenariosAPI = {
//   getAll: (params) => api.get("/scenarios", { params }),
//   getById: (id) => api.get(`/scenarios/${id}`),
//   getCategories: () => api.get("/scenarios/categories"),
//   getStatistics: (id) => api.get(`/scenarios/${id}/statistics`),
// };

// // Progress API
// export const progressAPI = {
//   submit: (data) => api.post("/progress/submit", data),
//   getUserProgress: (params) => api.get("/progress", { params }),
//   getLeaderboard: (limit) =>
//     api.get("/progress/leaderboard", { params: { limit } }),
// };

// export default api;

import axios from "axios";

const api = axios.create({
  baseURL: "https://scenario-api.caprover.al-arcade.com/api/",
  headers: { "Content-Type": "application/json" },
});

api.interceptors.request.use((config) => {
  const token = localStorage.getItem("token");
  if (token) {
    config.headers.Authorization = `Bearer ${token}`;
  }
  return config;
});

api.interceptors.response.use(
  (response) => response,
  (error) => {
    if (error.response?.status === 401) {
      localStorage.removeItem("token");
      window.location.href = "/login";
    }
    return Promise.reject(error);
  }
);

export default api;
