import { NavLink, useNavigate } from 'react-router-dom';
import { useAuth } from '../../context/AuthContext';
import { FiX ,FiMenu,FiHome, FiUser, FiLogOut, FiAward, FiClock, FiSettings } from 'react-icons/fi';
import { useState } from 'react';

export default function Navbar() {
  const [isOpen, setIsOpen] = useState(false);

  const toggleMenu = () => setIsOpen(!isOpen);

  const navLinkClass = ({ isActive }) =>
    `flex items-center gap-2 transition px-4 py-2 rounded-md ${
      isActive ? 'text-indigo-600 bg-indigo-50 lg:bg-transparent' : 'text-gray-600 hover:text-indigo-600 hover:bg-gray-50 lg:hover:bg-transparent'
    }`;
  const { user, logout } = useAuth();
  const navigate = useNavigate();

  const handleLogout = () => {
    logout();
    navigate('/login');
  };
return (
    <nav className="bg-white shadow-lg relative z-50">
      <div className="container mx-auto px-4">
        <div className="flex justify-between items-center h-16">
          {/* Logo */}
          <NavLink to="/" className="text-2xl font-bold text-indigo-600">
            MCQ App
          </NavLink>

          {/* Hamburger Button (Visible on mobile/tablet) */}
          <div className="lg:hidden">
            <button onClick={toggleMenu} className="text-gray-600 focus:outline-none p-2">
              {isOpen ? <FiX size={24} /> : <FiMenu size={24} />}
            </button>
          </div>

          {/* Desktop Menu */}
          <div className="hidden lg:flex items-center gap-6">
            <NavContent user={user} handleLogout={handleLogout} navLinkClass={navLinkClass} />
          </div>
        </div>

        {/* Mobile & Tablet Menu (Dropdown) */}
        <div 
          className={`lg:hidden overflow-hidden transition-all duration-300 ease-in-out ${
            isOpen ? 'max-h-screen border-t py-4' : 'max-h-0'
          }`}
        >
          <div className="flex flex-col gap-2">
            <NavContent 
              user={user} 
              handleLogout={handleLogout} 
              navLinkClass={navLinkClass} 
              isMobile={true} 
              closeMenu={() => setIsOpen(false)} 
            />
          </div>
        </div>
      </div>
    </nav>
  );
};

// مكون داخلي لتجنب تكرار الروابط
const NavContent = ({ user, handleLogout, navLinkClass, isMobile, closeMenu }) => {
  if (!user) {
    return (
      <div className={`flex ${isMobile ? 'flex-col gap-2' : 'items-center gap-4'}`}>
        <NavLink to="/login" onClick={closeMenu} className="text-gray-600 hover:text-indigo-600 px-4 py-2">Login</NavLink>
        <NavLink to="/register" onClick={closeMenu} className="bg-indigo-600 text-white px-4 py-2 rounded-lg text-center">Sign Up</NavLink>
      </div>
    );
  }

  return (
    <>
      <NavLink to="/" onClick={closeMenu} className={navLinkClass}><FiHome /> Quizzes</NavLink>
      <NavLink to="/leaderboard" onClick={closeMenu} className={navLinkClass}><FiAward /> Leaderboard</NavLink>
      <NavLink to="/history" onClick={closeMenu} className={navLinkClass}><FiClock /> History</NavLink>
      
      {user.role === 'admin' && (
        <NavLink to="/admin" onClick={closeMenu} className={navLinkClass}><FiSettings /> Admin</NavLink>
      )}
      
      <NavLink to="/profile" onClick={closeMenu} className={navLinkClass}><FiUser /> {user.username}</NavLink>
      
      <button 
        onClick={() => { handleLogout(); if(isMobile) closeMenu(); }} 
        className="flex items-center gap-2 text-red-500 hover:text-red-700 transition px-4 py-2"
      >
        <FiLogOut /> Logout
      </button>
    </>
  );

  // return (
  //   <nav className="bg-white shadow-lg">
  //     <div className="container mx-auto px-4">
  //       <div className="flex justify-between items-center h-16">
  //         <NavLink to="/" className="text-2xl font-bold text-indigo-600">MCQ App</NavLink>
  //         {user  ? (
  //           <div className="flex items-center gap-6">
  //             <NavLink to="/" className={({ isActive }) => (isActive ? 'text-indigo-600 flex items-center gap-2  hover:text-indigo-600 transition' : 'flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition')} >
  //               <FiHome /> Quizzes
  //             </NavLink>
  //             <NavLink to="/leaderboard" className={({ isActive }) => (isActive ? 'text-indigo-600 flex items-center gap-2  hover:text-indigo-600 transition' : 'flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition')}>
  //               <FiAward /> Leaderboard
  //             </NavLink>
  //             <NavLink to="/history" className={({ isActive }) => (isActive ? 'text-indigo-600 flex items-center gap-2  hover:text-indigo-600 transition' : 'flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition')}>
  //               <FiClock /> History
  //             </NavLink>
  //             {user.role === 'admin' && (
  //               <NavLink to="/admin" className={({ isActive }) => (isActive ? 'text-indigo-600 flex items-center gap-2  hover:text-indigo-600 transition' : 'flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition')}>
  //                 <FiSettings /> Admin
  //               </NavLink>
  //             )}
  //             <NavLink to="/profile" className={({ isActive }) => (isActive ? 'text-indigo-600 flex items-center gap-2  hover:text-indigo-600 transition' : 'flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition')}>
  //               <FiUser /> {user.username}
  //             </NavLink>
  //             <button onClick={handleLogout} className="flex items-center gap-2 text-red-500 hover:text-red-700 transition">
  //               <FiLogOut /> Logout
  //             </button>
  //           </div>
  //         ) : (
  //           <div className="flex items-center gap-4">
  //             <NavLink to="/login" className="text-gray-600 hover:text-indigo-600 transition">Login</NavLink>
  //             <NavLink to="/register" className="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition">Sign Up</NavLink>
  //           </div>
  //         )}
  //       </div>
  //     </div>
  //   </nav>
  // );
}