import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import { ToastContainer } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';
import { AuthProvider } from './context/AuthContext';
import ProtectedRoute from './components/Auth/ProtectedRoute';
import Login from './components/Auth/Login';
import Register from './components/Auth/Register';
import Navbar from './components/Layout/Navbar';
import QuizList from './components/Quiz/QuizList';
import QuizTake from './components/Quiz/QuizTake';
import QuizResult from './components/Quiz/QuizResult';
import Profile from './components/User/Profile';
import History from './components/User/History';
import Leaderboard from './components/User/Leaderboard';
import Dashboard from './components/Admin/Dashboard';
import ScenarioManager from './components/Admin/ScenarioManager';
import UserManager from './components/Admin/UserManager';
import QuizManager from './components/Admin/QuizManager';

function App() {
  return (
    <AuthProvider>
      <Router>
        <div className="min-h-screen bg-gray-100">
          <Navbar />
          <main className="container mx-auto px-4 py-8">
            <Routes>
              <Route path="/login" element={<Login />} />
              <Route path="/register" element={<Register />} />
              <Route path="/" element={<ProtectedRoute><QuizList /></ProtectedRoute>} />
              <Route path="/quiz/:id" element={<ProtectedRoute><QuizTake /></ProtectedRoute>} />
              <Route path="/result/:attemptId" element={<ProtectedRoute><QuizResult /></ProtectedRoute>} />
              <Route path="/profile" element={<ProtectedRoute><Profile /></ProtectedRoute>} />
              <Route path="/history" element={<ProtectedRoute><History /></ProtectedRoute>} />
              <Route path="/leaderboard" element={<Leaderboard />} />
              <Route path="/admin" element={<ProtectedRoute adminOnly><Dashboard /></ProtectedRoute>} />
              <Route path="/admin/scenarios" element={<ProtectedRoute adminOnly><ScenarioManager /></ProtectedRoute>} />
              <Route path="/admin/users" element={<ProtectedRoute adminOnly><UserManager /></ProtectedRoute>} />
              <Route path="/admin/quizzes" element={<ProtectedRoute adminOnly><QuizManager /></ProtectedRoute>} />
            </Routes>
          </main>
          <ToastContainer position="bottom-right" />
        </div>
      </Router>
    </AuthProvider>
  );
}

export default App;