const express = require("express");
const router = express.Router();
const {
  getDashboard,
  getAllUsers,
  updateUser,
  deleteUser,
  getAllScenarios,
  createScenario,
  updateScenario,
  deleteScenario,
  getAllQuizzes,
  createQuiz,
  updateQuiz,
  deleteQuiz,
} = require("../controllers/adminController");
const auth = require("../middleware/auth");
const admin = require("../middleware/admin");

router.use(auth, admin);

router.get("/dashboard", getDashboard);
router.get("/users", getAllUsers);
router.put("/users/:id", updateUser);
router.delete("/users/:id", deleteUser);
router.get("/scenarios", getAllScenarios);
router.post("/scenarios", createScenario);
router.put("/scenarios/:id", updateScenario);
router.delete("/scenarios/:id", deleteScenario);
router.get("/quizzes", getAllQuizzes);
router.post("/quizzes", createQuiz);
router.put("/quizzes/:id", updateQuiz);
router.delete("/quizzes/:id", deleteQuiz);

module.exports = router;
