const express = require("express");
const router = express.Router();
const {
  getProfile,
  updateProfile,
  changePassword,
  getHistory,
  getLeaderboard,
} = require("../controllers/userController");
const auth = require("../middleware/auth");

router.get("/profile", auth, getProfile);
router.put("/profile", auth, updateProfile);
router.put("/password", auth, changePassword);
router.get("/history", auth, getHistory);
router.get("/leaderboard", getLeaderboard);

module.exports = router;
