import { useState, useEffect } from 'react';
import api from '../../services/api';
import Loading from '../Common/Loading';
import { FiAward } from 'react-icons/fi';

export default function Leaderboard() {
  const [leaderboard, setLeaderboard] = useState([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    api.get('/user/leaderboard').then(res => setLeaderboard(res.data)).finally(() => setLoading(false));
  }, []);

  if (loading) return <Loading />;

  const getMedalColor = (index) => {
    if (index === 0) return 'text-yellow-500';
    if (index === 1) return 'text-gray-400';
    if (index === 2) return 'text-amber-600';
    return 'text-gray-300';
  };

  return (
    <div className="max-w-3xl mx-auto">
      <div className="text-center mb-8">
        <h1 className="text-3xl font-bold text-gray-800">Leaderboard</h1>
        <p className="text-gray-600 mt-2">Top performers in financial scenarios</p>
      </div>
      {leaderboard.length === 0 ? (
        <div className="bg-white rounded-xl shadow-lg p-8 text-center">
          <p className="text-gray-500 text-lg">No rankings yet. Be the first!</p>
        </div>
      ) : (
        <div className="bg-white rounded-xl shadow-lg overflow-hidden">
          {leaderboard.map((user, index) => (
            <div key={user.id} className={`flex items-center gap-4 p-4 ${index < 3 ? 'bg-gradient-to-r from-indigo-50 to-white' : ''} ${index !== leaderboard.length - 1 ? 'border-b' : ''}`}>
              <div className="w-10 text-center">
                {index < 3 ? <FiAward className={`mx-auto ${getMedalColor(index)}`} size={24} /> : <span className="text-gray-500 font-medium">{index + 1}</span>}
              </div>
              <div className="w-12 h-12 bg-indigo-600 rounded-full flex items-center justify-center text-white font-bold">
                {user.username.charAt(0).toUpperCase()}
              </div>
              <div className="flex-1">
                <h3 className="font-semibold text-gray-800">{user.username}</h3>
                <p className="text-sm text-gray-500">{user.quizzes_taken} quizzes completed</p>
              </div>
              <div className="text-right">
                <div className="text-2xl font-bold text-indigo-600">{user.total_score}</div>
                <div className="text-sm text-gray-500">points</div>
              </div>
            </div>
          ))}
        </div>
      )}
    </div>
  );
}