const GivensTable = ({ data }) => {
    if (!data || !data.headers || !data.rows) {
        return <div className="text-gray-500">No data available</div>;
    }

    const formatValue = (value, header) => {
        if (value === null || value === undefined) return '-';
        
        const lowerHeader = header.toLowerCase();
        
        if (lowerHeader.includes('price')) {
            return `$${parseFloat(value).toFixed(2)}`;
        }
        if (lowerHeader.includes('z-score') || lowerHeader.includes('z_score')) {
            const num = parseFloat(value);
            return (
                <span className={num > 2 ? 'text-red-600 font-semibold' : num < -2 ? 'text-green-600 font-semibold' : ''}>
                    {num.toFixed(2)}
                </span>
            );
        }
        if (lowerHeader.includes('date')) {
            return new Date(value).toLocaleDateString();
        }
        
        return value;
    };

    const getHeaderKey = (header) => {
        return header.toLowerCase().replace(/[\s-]/g, '_');
    };

    return (
        <div className="overflow-x-auto rounded-lg border border-gray-200">
            <table className="min-w-full divide-y divide-gray-200">
                <thead className="bg-gray-50">
                    <tr>
                        {data.headers.map((header, idx) => (
                            <th
                                key={idx}
                                className="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"
                            >
                                {header}
                            </th>
                        ))}
                    </tr>
                </thead>
                <tbody className="bg-white divide-y divide-gray-200">
                    {data.rows.map((row, rowIdx) => (
                        <tr key={rowIdx} className="hover:bg-gray-50">
                            {data.headers.map((header, colIdx) => {
                                const key = getHeaderKey(header);
                                const value = row[key] || row[header.toLowerCase()];
                                return (
                                    <td
                                        key={colIdx}
                                        className="px-4 py-3 text-sm text-gray-900 whitespace-nowrap"
                                    >
                                        {formatValue(value, header)}
                                    </td>
                                );
                            })}
                        </tr>
                    ))}
                </tbody>
            </table>
        </div>
    );
};

export default GivensTable;