import { CheckCircle, XCircle, X, ArrowRight } from 'lucide-react';

const FeedbackModal = ({ isOpen, onClose, feedback, onNext }) => {
    if (!isOpen || !feedback) return null;

    const isCorrect = feedback.correct;

    return (
        <div className="fixed inset-0 z-50 overflow-y-auto">
            <div className="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:p-0">
                {/* Backdrop */}
                <div 
                    className="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"
                    onClick={onClose}
                />

                {/* Modal */}
                <div className="relative inline-block w-full max-w-lg p-6 my-8 overflow-hidden text-left align-middle transition-all transform bg-white shadow-xl rounded-2xl">
                    {/* Close button */}
                    <button
                        onClick={onClose}
                        className="absolute top-4 right-4 text-gray-400 hover:text-gray-600"
                    >
                        <X className="h-6 w-6" />
                    </button>

                    {/* Header */}
                    <div className="flex items-center space-x-3 mb-4">
                        {isCorrect ? (
                            <CheckCircle className="h-10 w-10 text-green-500" />
                        ) : (
                            <XCircle className="h-10 w-10 text-red-500" />
                        )}
                        <h3 className={`text-2xl font-bold ${isCorrect ? 'text-green-700' : 'text-red-700'}`}>
                            {isCorrect ? 'Correct!' : 'Incorrect'}
                        </h3>
                    </div>

                    {/* Content */}
                    <div className="mt-4 space-y-4">
                        {!isCorrect && feedback.correctAnswer && (
                            <div className="p-4 bg-green-50 rounded-lg border border-green-200">
                                <p className="text-sm font-medium text-green-800">Correct Answer:</p>
                                <p className="mt-1 text-green-900">{feedback.correctAnswer}</p>
                            </div>
                        )}

                        <div className={`p-4 rounded-lg ${isCorrect ? 'bg-green-50 border border-green-200' : 'bg-gray-50 border border-gray-200'}`}>
                            <p className={`text-sm font-medium ${isCorrect ? 'text-green-800' : 'text-gray-700'}`}>
                                {isCorrect ? 'Why this is correct:' : 'Explanation:'}
                            </p>
                            <p className={`mt-2 ${isCorrect ? 'text-green-900' : 'text-gray-900'}`}>
                                {isCorrect ? feedback.rationale : feedback.explanation}
                            </p>
                        </div>

                        {!isCorrect && feedback.rationale && (
                            <div className="p-4 bg-blue-50 rounded-lg border border-blue-200">
                                <p className="text-sm font-medium text-blue-800">Why the correct answer works:</p>
                                <p className="mt-2 text-blue-900">{feedback.rationale}</p>
                            </div>
                        )}
                    </div>

                    {/* Actions */}
                    <div className="mt-6 flex justify-end space-x-3">
                        <button
                            onClick={onClose}
                            className="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-md hover:bg-gray-200"
                        >
                            Review Scenario
                        </button>
                        {onNext && (
                            <button
                                onClick={onNext}
                                className="flex items-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 rounded-md hover:bg-indigo-700"
                            >
                                Next Scenario
                                <ArrowRight className="ml-2 h-4 w-4" />
                            </button>
                        )}
                    </div>
                </div>
            </div>
        </div>
    );
};

export default FeedbackModal;