import { CheckCircle, XCircle, AlertCircle, X } from 'lucide-react';

const Alert = ({ type = 'info', message, onClose }) => {
    const styles = {
        success: {
            bg: 'bg-green-50',
            border: 'border-green-400',
            text: 'text-green-800',
            icon: <CheckCircle className="h-5 w-5 text-green-400" />
        },
        error: {
            bg: 'bg-red-50',
            border: 'border-red-400',
            text: 'text-red-800',
            icon: <XCircle className="h-5 w-5 text-red-400" />
        },
        warning: {
            bg: 'bg-yellow-50',
            border: 'border-yellow-400',
            text: 'text-yellow-800',
            icon: <AlertCircle className="h-5 w-5 text-yellow-400" />
        },
        info: {
            bg: 'bg-blue-50',
            border: 'border-blue-400',
            text: 'text-blue-800',
            icon: <AlertCircle className="h-5 w-5 text-blue-400" />
        }
    };

    const style = styles[type];

    return (
        <div className={`${style.bg} ${style.border} border rounded-md p-4`}>
            <div className="flex">
                <div className="flex-shrink-0">{style.icon}</div>
                <div className={`ml-3 ${style.text}`}>
                    <p className="text-sm font-medium">{message}</p>
                </div>
                {onClose && (
                    <div className="ml-auto pl-3">
                        <button
                            onClick={onClose}
                            className={`${style.text} hover:opacity-75`}
                        >
                            <X className="h-5 w-5" />
                        </button>
                    </div>
                )}
            </div>
        </div>
    );
};

export default Alert;