import { Link, useNavigate } from 'react-router-dom';
import { useAuth } from '../../context/AuthContext';
import { FiHome, FiUser, FiLogOut, FiAward, FiClock, FiSettings } from 'react-icons/fi';

export default function Navbar() {
  const { user, logout } = useAuth();
  const navigate = useNavigate();

  const handleLogout = () => {
    logout();
    navigate('/login');
  };

  return (
    <nav className="bg-white shadow-lg">
      <div className="container mx-auto px-4">
        <div className="flex justify-between items-center h-16">
          <Link to="/" className="text-2xl font-bold text-indigo-600">MCQ App</Link>
          {user  ? (
            <div className="flex items-center gap-6">
              <Link to="/" className="flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition">
                <FiHome /> Quizzes
              </Link>
              <Link to="/leaderboard" className="flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition">
                <FiAward /> Leaderboard
              </Link>
              <Link to="/history" className="flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition">
                <FiClock /> History
              </Link>
              {user.role === 'admin' && (
                <Link to="/admin" className="flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition">
                  <FiSettings /> Admin
                </Link>
              )}
              <Link to="/profile" className="flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition">
                <FiUser /> {user.username}
              </Link>
              <button onClick={handleLogout} className="flex items-center gap-2 text-red-500 hover:text-red-700 transition">
                <FiLogOut /> Logout
              </button>
            </div>
          ) : (
            <div className="flex items-center gap-4">
              <Link to="/login" className="text-gray-600 hover:text-indigo-600 transition">Login</Link>
              <Link to="/register" className="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition">Sign Up</Link>
            </div>
          )}
        </div>
      </div>
    </nav>
  );
}