import { useState, useEffect } from 'react';
import { Link } from 'react-router-dom';
import api from '../../services/api';
import Loading from '../Common/Loading';
import { FiClock, FiCheckCircle, FiPlay } from 'react-icons/fi';

export default function QuizList() {
  const [quizzes, setQuizzes] = useState([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    api.get('/quiz').then(res => setQuizzes(res.data)).finally(() => setLoading(false));
  }, []);

  if (loading) return <Loading />;

  return (
    <div>
      <div className="mb-8">
        <h1 className="text-3xl font-bold text-gray-800">Available Quizzes</h1>
        <p className="text-gray-600 mt-2">Test your financial knowledge with our curated scenarios</p>
      </div>
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {quizzes.map(quiz => (
          <div key={quiz.id} className="bg-white rounded-xl shadow-lg overflow-hidden card-hover">
            <div className="gradient-bg p-6">
              <h2 className="text-xl font-bold text-white">{quiz.title}</h2>
            </div>
            <div className="p-6">
              <p className="text-gray-600 mb-4">{quiz.description}</p>
              <div className="flex items-center gap-4 text-sm text-gray-500 mb-4">
                <span className="flex items-center gap-1"><FiCheckCircle /> {quiz.question_count} Questions</span>
                {quiz.time_limit > 0 && <span className="flex items-center gap-1"><FiClock /> {quiz.time_limit} min</span>}
              </div>
              <div className="flex items-center justify-between">
                <span className="text-sm text-gray-500">Pass: {quiz.passing_score}%</span>
                <Link to={`/quiz/${quiz.id}`} className="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition flex items-center gap-2">
                  <FiPlay /> Start Quiz
                </Link>
              </div>
            </div>
          </div>
        ))}
      </div>
      {quizzes.length === 0 && (
        <div className="text-center py-12">
          <p className="text-gray-500 text-lg">No quizzes available yet.</p>
        </div>
      )}
    </div>
  );
}