export default function QuestionCard({ scenario, selectedAnswer, onSelectAnswer, showResult, answerResult }) {
  const givensTable = typeof scenario.givens_table === 'string' ? JSON.parse(scenario.givens_table) : scenario.givens_table;
  
  const options = [
    { text: scenario.best_answer, isCorrect: true },
    { text: scenario.other_option1, explanation: scenario.other_option1_exp },
    { text: scenario.other_option2, explanation: scenario.other_option2_exp },
    { text: scenario.other_option3, explanation: scenario.other_option3_exp }
  ].sort(() => Math.random() - 0.5);

  const getOptionClass = (option) => {
    let baseClass = 'quiz-option p-4 rounded-lg border-2 cursor-pointer mb-3';
    if (!showResult) {
      return `${baseClass} ${selectedAnswer === option.text ? 'selected' : 'border-gray-200'}`;
    }
    if (option.text === answerResult?.correctAnswer) {
      return `${baseClass} correct`;
    }
    if (selectedAnswer === option.text && !answerResult?.isCorrect) {
      return `${baseClass} incorrect`;
    }
    return `${baseClass} border-gray-200`;
  };

  return (
    <div className="bg-white rounded-xl shadow-lg overflow-hidden">
      <div className={`p-4 ${scenario.event_type === 'major' ? 'bg-red-500' : 'bg-blue-500'}`}>
        <span className="text-white font-semibold uppercase text-sm">{scenario.event_type} Event</span>
      </div>
      <div className="p-6">
        <h2 className="text-xl font-bold text-gray-800 mb-4">{scenario.title}</h2>
        <p className="text-gray-600 mb-4">{scenario.short_description}</p>
        {givensTable && (
          <div className="bg-gray-50 rounded-lg p-4 mb-4">
            <h3 className="font-semibold text-gray-700 mb-2">Given Information</h3>
            <div className="grid grid-cols-2 md:grid-cols-3 gap-2">
              {Object.entries(givensTable).map(([key, value]) => (
                <div key={key} className="text-sm">
                  <span className="font-medium text-gray-600">{key}:</span>{' '}
                  <span className="text-gray-800">{value}</span>
                </div>
              ))}
            </div>
          </div>
        )}
        <div className="bg-indigo-50 rounded-lg p-4 mb-6">
          <p className="text-gray-700">{scenario.scenario_paragraph}</p>
        </div>
        <h3 className="font-semibold text-gray-700 mb-3">Select your answer:</h3>
        <div>
          {options.map((option, index) => (
            <div key={index} className={getOptionClass(option)} onClick={() => !showResult && onSelectAnswer(option.text)}>
              <p className="text-gray-800">{option.text}</p>
            </div>
          ))}
        </div>
        {showResult && (
          <div className={`mt-4 p-4 rounded-lg ${answerResult?.isCorrect ? 'bg-green-50 border border-green-200' : 'bg-red-50 border border-red-200'}`}>
            <h4 className={`font-semibold ${answerResult?.isCorrect ? 'text-green-700' : 'text-red-700'}`}>
              {answerResult?.isCorrect ? '✓ Correct!' : '✗ Incorrect'}
            </h4>
            <p className="text-gray-700 mt-2"><strong>Rationale:</strong> {answerResult?.rationale}</p>
          </div>
        )}
      </div>
    </div>
  );
}