const express = require("express");
const router = express.Router();
const {
  getAllQuizzes,
  getQuizById,
  startQuiz,
  submitAnswer,
  completeQuiz,
  getQuizResult,
  getAllScenarios,
  getScenarioById,
} = require("../controllers/quizController");
const auth = require("../middleware/auth");

router.get("/", auth, getAllQuizzes);
router.get("/scenarios", auth, getAllScenarios);
router.get("/scenarios/:id", auth, getScenarioById);
router.get("/:id", auth, getQuizById);
router.post("/:id/start", auth, startQuiz);
router.post("/answer", auth, submitAnswer);
router.post("/complete", auth, completeQuiz);
router.get("/result/:attemptId", auth, getQuizResult);

module.exports = router;
