import { Link } from 'react-router-dom';
import { Clock, CheckCircle, ChevronRight, Tag } from 'lucide-react';

const ScenarioCard = ({ scenario }) => {
    const difficultyColors = {
        easy: 'bg-green-100 text-green-800',
        medium: 'bg-yellow-100 text-yellow-800',
        hard: 'bg-orange-100 text-orange-800',
        expert: 'bg-red-100 text-red-800'
    };

    return (
        <Link
            to={`/scenarios/${scenario.id}`}
            className="block bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow duration-200 overflow-hidden border border-gray-100"
        >
            <div className="p-6">
                <div className="flex items-start justify-between">
                    <div className="flex-1">
                        <div className="flex items-center space-x-2 mb-2">
                            <span className={`px-2 py-1 text-xs font-medium rounded-full ${difficultyColors[scenario.difficulty_level]}`}>
                                {scenario.difficulty_level}
                            </span>
                            {scenario.category && (
                                <span className="px-2 py-1 text-xs font-medium rounded-full bg-indigo-100 text-indigo-800">
                                    {scenario.category}
                                </span>
                            )}
                            {scenario.isCompleted && (
                                <CheckCircle className="h-5 w-5 text-green-500" />
                            )}
                        </div>
                        <h3 className="text-lg font-semibold text-gray-900 mb-2">
                            {scenario.title}
                        </h3>
                        <p className="text-gray-600 text-sm line-clamp-2">
                            {scenario.short_description}
                        </p>
                    </div>
                    <ChevronRight className="h-5 w-5 text-gray-400 shrink-0 ml-4" />
                </div>

                {scenario.tags && scenario.tags.length > 0 && (
                    <div className="mt-4 flex items-center flex-wrap gap-2">
                        <Tag className="h-4 w-4 text-gray-400" />
                        {scenario.tags.slice(0, 3).map((tag, idx) => (
                            <span
                                key={idx}
                                className="text-xs text-gray-500 bg-gray-100 px-2 py-1 rounded"
                            >
                                {tag}
                            </span>
                        ))}
                    </div>
                )}
            </div>
        </Link>
    );
};

export default ScenarioCard;