const express = require("express");
const router = express.Router();
const progressController = require("../controllers/progressController");
const { authenticateToken } = require("../middleware/auth");
const {
  progressValidation,
  paginationValidation,
} = require("../middleware/validation");

router.post(
  "/submit",
  authenticateToken,
  progressValidation,
  progressController.submitAnswer
);
router.get(
  "/",
  authenticateToken,
  paginationValidation,
  progressController.getUserProgress
);
router.get(
  "/leaderboard",
  paginationValidation,
  progressController.getLeaderboard
);

module.exports = router;
