import { BrowserRouter as Router, Routes, Route, Navigate } from 'react-router-dom';
import { AuthProvider } from './context/AuthContext';
import Navbar from './components/common/Navbar';
import ProtectedRoute from './components/common/ProtectedRoute';
import LoginForm from './components/auth/LoginForm';
import RegisterForm from './components/auth/RegisterForm';
import ScenarioDashboard from './components/scenario/ScenarioDashboard';
import ScenarioDetail from './components/scenario/ScenarioDetail';
import UserProfile from './components/profile/UserProfile';

function App() {
    return (
         <Router>
        <AuthProvider>
           
                <div className="min-h-screen bg-gray-50">
                    <Navbar />
                    <main>
                        <Routes>
                            <Route path="/" element={<Navigate to="/scenarios" replace />} />
                            <Route path="/login" element={<LoginForm />} />
                            <Route path="/register" element={<RegisterForm />} />
                            <Route path="/scenarios" element={<ScenarioDashboard />} />
                            <Route path="/scenarios/:id" element={<ScenarioDetail />} />
                            <Route 
                                path="/profile" 
                                element={
                                    <ProtectedRoute>
                                        <UserProfile />
                                    </ProtectedRoute>
                                } 
                            />
                        </Routes>
                    </main>
                </div>
          
        </AuthProvider>
          </Router>
    );
}

export default App;