import { NavLink, useNavigate } from 'react-router-dom';
import { useAuth } from '../../context/AuthContext';
import { FiHome, FiUser, FiLogOut, FiAward, FiClock, FiSettings } from 'react-icons/fi';

export default function Navbar() {
  const { user, logout } = useAuth();
  const navigate = useNavigate();

  const handleLogout = () => {
    logout();
    navigate('/login');
  };

  return (
    <nav className="bg-white shadow-lg">
      <div className="container mx-auto px-4">
        <div className="flex justify-between items-center h-16">
          <NavLink to="/" className="text-2xl font-bold text-indigo-600">MCQ App</NavLink>
          {user  ? (
            <div className="flex items-center gap-6">
              <NavLink to="/" className={({ isActive }) => (isActive ? 'text-indigo-600 flex items-center gap-2  hover:text-indigo-600 transition' : 'flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition')} >
                <FiHome /> Quizzes
              </NavLink>
              <NavLink to="/leaderboard" className={({ isActive }) => (isActive ? 'text-indigo-600 flex items-center gap-2  hover:text-indigo-600 transition' : 'flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition')}>
                <FiAward /> Leaderboard
              </NavLink>
              <NavLink to="/history" className={({ isActive }) => (isActive ? 'text-indigo-600 flex items-center gap-2  hover:text-indigo-600 transition' : 'flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition')}>
                <FiClock /> History
              </NavLink>
              {user.role === 'admin' && (
                <NavLink to="/admin" className={({ isActive }) => (isActive ? 'text-indigo-600 flex items-center gap-2  hover:text-indigo-600 transition' : 'flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition')}>
                  <FiSettings /> Admin
                </NavLink>
              )}
              <NavLink to="/profile" className={({ isActive }) => (isActive ? 'text-indigo-600 flex items-center gap-2  hover:text-indigo-600 transition' : 'flex items-center gap-2 text-gray-600 hover:text-indigo-600 transition')}>
                <FiUser /> {user.username}
              </NavLink>
              <button onClick={handleLogout} className="flex items-center gap-2 text-red-500 hover:text-red-700 transition">
                <FiLogOut /> Logout
              </button>
            </div>
          ) : (
            <div className="flex items-center gap-4">
              <NavLink to="/login" className="text-gray-600 hover:text-indigo-600 transition">Login</NavLink>
              <NavLink to="/register" className="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 transition">Sign Up</NavLink>
            </div>
          )}
        </div>
      </div>
    </nav>
  );
}