import { useState } from 'react';
import { CheckCircle, Circle } from 'lucide-react';

const AnswerOptions = ({ answers, onSelect, disabled, selectedAnswer, correctAnswer, showFeedback }) => {
    const [hoveredId, setHoveredId] = useState(null);

    const getOptionStyle = (answer) => {
        if (!showFeedback) {
            if (selectedAnswer === answer.answer) {
                return 'border-indigo-500 bg-indigo-50 ring-2 ring-indigo-500';
            }
            if (hoveredId === answer.id && !disabled) {
                return 'border-gray-300 bg-gray-50';
            }
            return 'border-gray-200 hover:border-gray-300';
        }

        // Show feedback
        if (answer.answer === correctAnswer) {
            return 'border-green-500 bg-green-50 ring-2 ring-green-500';
        }
        if (selectedAnswer === answer.answer && answer.answer !== correctAnswer) {
            return 'border-red-500 bg-red-50 ring-2 ring-red-500';
        }
        return 'border-gray-200 opacity-50';
    };

    return (
        <div className="space-y-3">
            <h3 className="text-lg font-medium text-gray-900 mb-4">Select your answer:</h3>
            {answers.map((answer) => (
                <button
                    key={answer.id}
                    onClick={() => !disabled && onSelect(answer)}
                    disabled={disabled}
                    onMouseEnter={() => setHoveredId(answer.id)}
                    onMouseLeave={() => setHoveredId(null)}
                    className={`w-full text-left p-4 rounded-lg border-2 transition-all duration-200 ${getOptionStyle(answer)} ${
                        disabled ? 'cursor-not-allowed' : 'cursor-pointer'
                    }`}
                >
                    <div className="flex items-start">
                        <div className="shrink-0 mt-0.5">
                            {showFeedback && answer.answer === correctAnswer ? (
                                <CheckCircle className="h-5 w-5 text-green-500" />
                            ) : selectedAnswer === answer.answer ? (
                                <CheckCircle className={`h-5 w-5 ${showFeedback ? 'text-red-500' : 'text-indigo-500'}`} />
                            ) : (
                                <Circle className="h-5 w-5 text-gray-400" />
                            )}
                        </div>
                        <span className="ml-3 text-gray-900">{answer.answer}</span>
                    </div>
                </button>
            ))}
        </div>
    );
};

export default AnswerOptions;