const express = require("express");
const router = express.Router();
const scenarioController = require("../controllers/scenarioController");
const { authenticateToken, optionalAuth } = require("../middleware/auth");
const {
  scenarioIdValidation,
  paginationValidation,
} = require("../middleware/validation");

router.get(
  "/",
  optionalAuth,
  paginationValidation,
  scenarioController.getAllScenarios
);
router.get("/categories", scenarioController.getCategories);
router.get(
  "/:id",
  optionalAuth,
  scenarioIdValidation,
  scenarioController.getScenarioById
);
router.get(
  "/:id/statistics",
  scenarioIdValidation,
  scenarioController.getScenarioStatistics
);

module.exports = router;
