import { Link, useNavigate } from 'react-router-dom';
import { useAuth } from '../../context/ContextUsing';
import { LogOut, User, BookOpen, Trophy } from 'lucide-react';

const Navbar = () => {
    const { user, logout, isAuthenticated } = useAuth();
    const navigate = useNavigate();

    const handleLogout = async () => {
        await logout();
        navigate('/login');
    };

    return (
        <nav className="bg-white shadow-lg">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="flex justify-between h-16">
                    <div className="flex items-center">
                        <Link to="/" className="flex items-center space-x-2">
                            <BookOpen className="h-8 w-8 text-indigo-600" />
                            <span className="font-bold text-xl text-gray-900">
                                ScenarioLearn
                            </span>
                        </Link>
                        
                        <div className="hidden md:flex ml-10 space-x-8">
                            <Link
                                to="/scenarios"
                                className="text-gray-600 hover:text-indigo-600 px-3 py-2 text-sm font-medium"
                            >
                                Scenarios
                            </Link>
                           
                        </div>
                    </div>

                    <div className="flex items-center space-x-4">
                        {isAuthenticated ? (
                            <>
                                <Link
                                    to="/profile"
                                    className="flex items-center text-gray-600 hover:text-indigo-600"
                                >
                                    <User className="h-5 w-5 mr-1" />
                                    <span className="hidden sm:inline">{user?.username}</span>
                                </Link>
                                <button
                                    onClick={handleLogout}
                                    className="flex items-center text-gray-600 hover:text-red-600"
                                >
                                    <LogOut className="h-5 w-5" />
                                </button>
                            </>
                        ) : (
                            <>
                                <Link
                                    to="/login"
                                    className="text-gray-600 hover:text-indigo-600 px-3 py-2 text-sm font-medium"
                                >
                                    Login
                                </Link>
                                <Link
                                    to="/register"
                                    className="bg-indigo-600 text-white px-4 py-2 rounded-md text-sm font-medium hover:bg-indigo-700"
                                >
                                    Sign Up
                                </Link>
                            </>
                        )}
                    </div>
                </div>
            </div>
        </nav>
    );
};

export default Navbar;