import http from "k6/http";
import { check, sleep } from "k6";

export let options = {
  // بنشغل داشبورد عشان تشوفي اللحظة اللي هيقع فيها لايف
  // ومهم جداً: لو السيرفر وقع، وقف التست فوراً عشان مايحصلش Ban
  thresholds: {
    http_req_failed: [{ threshold: "rate<0.01", abortOnFail: true }], // لو الفشل زاد عن 1% وقف
    http_req_duration: ["p(95)<2000"], // لو الرد بقى ابطأ من ثانيتين ده يعتبر فشل
  },
  stages: [
    // اطلع من 0 لـ 500 يوزر ببطء شديد على مدار 10 دقايق
    // ده هيديكي فرصة تشوفي بالظبط عند الدقيقة كام السيرفر مات
    { duration: "10m", target: 500 },
  ],
};

export default function () {
  let res = http.get("https://www.thebasekuwait.com/");

  check(res, { "status is 200": (r) => r.status === 200 });
  sleep(1);
}
