import os
from dataclasses import dataclass

# Configuration Management

@dataclass
class AppConfig:
    minio_endpoint: str
    minio_access_key: str
    minio_secret_key: str
    minio_bucket: str
    n8n_webhook_url: str

    @classmethod
    def from_env(cls) -> 'AppConfig':
        return cls(
            minio_endpoint=os.getenv("MINIO_ENDPOINT", "http://minio:9000"),
            minio_access_key=os.getenv("MINIO_ACCESS_KEY"),
            minio_secret_key=os.getenv("MINIO_SECRET_KEY"),
            minio_bucket="coversation",
            n8n_webhook_url=os.getenv("N8N_WEBHOOK_URL")
        )