from fastapi import UploadFile
from abc import ABC, abstractmethod
import sys
sys.path.append("../")
from repositories import WebhookClient, StorageRepository
from core import MessageType, ResponseStatus


class MessageHandler(ABC):
    @abstractmethod
    def handle(self, **kwargs) -> dict:
        pass

class AudioMessageHandler():
    def __init__(self, storage_repo: StorageRepository, webhook_client: WebhookClient, bucket: str):
        self.storage_repo = storage_repo
        self.webhook_client = webhook_client
        self.bucket = bucket

    def handle(self, file: UploadFile, **kwargs) -> dict:
        file_path = f"audio/{file.filename}"
        self.storage_repo.upload_file(file.file, self.bucket, file_path)
        print(f"Uploaded {file.filename} to MinIO.")
        
        payload = {"type": MessageType.AUDIO, "filename": file.filename}
        self.webhook_client.send_webhook(payload)
        
        return {"status": ResponseStatus.SUCCESS, "message": "Message received and forwarded to n8n."}

