import requests
from fastapi import HTTPException
from abc import ABC, abstractmethod
class WebhookClient(ABC):
    @abstractmethod
    def send_webhook(self, payload: dict) -> None:
        pass

class N8NWebhookClient(WebhookClient):
    def __init__(self, webhook_url: str):
        self.webhook_url = webhook_url

    def send_webhook(self, payload: dict) -> None:
        if not self.webhook_url:
            raise HTTPException(status_code=500, detail="N8N_WEBHOOK_URL is not configured.")
        
        try:
            response = requests.post(self.webhook_url, json=payload)
            response.raise_for_status()
            print(f"Sent payload to n8n webhook: {payload}")
        except requests.exceptions.RequestException as e:
            print(f"Error sending webhook to n8n: {e}")
            raise HTTPException(status_code=500, detail=f"Failed to send webhook to n8n: {e}")
