
from abc import ABC, abstractmethod
import sys
sys.path.append("../")
from repositories import WebhookClient
from core import MessageType, ResponseStatus
class TextMessageHandler():
    def __init__(self, webhook_client: WebhookClient):
        self.webhook_client = webhook_client

    def handle(self, text: str, **kwargs) -> dict:
        print(f"Received text message: {text}")
        payload = {"type": MessageType.TEXT, "message": text}
        self.webhook_client.send_webhook(payload)
        
        return {"status": ResponseStatus.SUCCESS, "message": "Message received and forwarded to n8n."}

