from fastapi import Request
from fastapi import APIRouter
import logging

router = APIRouter(tags=["System"])
logger = logging.getLogger("uvicorn.error")

@router.get("/health")
async def health_check(request: Request):
    """Health check endpoint using the shared container."""
    container = request.app.state.container
    try:
        health_status = container.health_service.get_health_status()
        health_status.update({
            "openai_service_status": "available" if container.openai_service.is_available() else "unavailable",
            "agent_service_status": "available" if container.agent_service.is_available() else "unavailable",
            "minio_endpoint": container.config.minio_endpoint,
            "minio_bucket": container.config.minio_bucket
        })
        return health_status
    except Exception as e:
        print(f"Health check error: {e}")
        return {"status": "error", "message": str(e)}

@router.get("/api-info")
async def root():
    """Root endpoint with API info"""
    return {"service": "Unified Chat API with Local Agent", "version": "2.2.0-lifespan", "status": "running"}
