from pydantic import BaseModel
from typing import Literal, List

class SynthesisRequest(BaseModel):
    text: str
    language: Literal["ar", "en"]


class Segment(BaseModel):
    """Defines a single language-tagged text segment."""
    text: str
    language: Literal["ar", "en"]

class SequenceSynthesisRequest(BaseModel):
    """Defines the request body for the new endpoint, which is a list of segments."""
    segments: List[Segment]