import logging
tashkeel_agent_prompt = "شكل الكلام"
logger = logging.getLogger(__name__)

class TashkeelAgent:
    """Agent to apply Arabic (Egyptian) diacritization on text for TTS"""

    def __init__(self, openai_service):
        self.openai_service = openai_service

    def apply_tashkeel(self, text: str) -> str:
        """Send text to LLM and return fully diacritized version"""
        try:
            if not self.openai_service.is_available():
                logger.warning("OpenAI service not available for TashkeelAgent")
                return text  # fallback: return original
            messages = [
                {"role": "system", "content": tashkeel_agent_prompt},
                {"role": "user", "content": text}
            ]
            response = self.openai_service.client.chat.completions.create(
                model="gpt-4o-mini",  # أو أي موديل خفيف سريع
                messages=messages,
                temperature=0.1
            )
            return response.choices[0].message.content.strip()
        except Exception as e:
            logger.error(f"TashkeelAgent error: {e}")
            return text  # fallback
