import requests
import json 

chat_url = "https://voice-agent.caprover.al-arcade.com/chat"
chat_payload = {
    'student_id': 'student_001',
    'text': 'how do i open this gate ',
    'game_context': 'The user is in the jungle level trying to open a door.'
}
output_filename = "agent_response_final.wav"

print(f" Sending POST request to {chat_url} ")
chat_response = requests.post(chat_url, data=chat_payload)
response_data = chat_response.json()
print("Server Confirmation:")
print(json.dumps(response_data, indent=2, ensure_ascii=False))
print("-" * 40)



agent_text = response_data.get("agent_response")
audio_url = response_data.get("audio_filepath")



print(f"Downloading audio from the provided URL ")

audio_response = requests.get(audio_url, stream=True)
audio_response.raise_for_status()

with open(output_filename, 'wb') as audio_file:
    for chunk in audio_response.iter_content(chunk_size=8192):
        audio_file.write(chunk)

print("-" * 40)
print("--- Download Complete ---")
print(f"Agent's Text Response: '{agent_text}'")
print(f"Audio file saved as: '{output_filename}'")