import os
from .base_tts_service import BaseTTSService
from .custom_tts_service import CustomTTSService
from services.openai_service import OpenAIService # We'll modify OpenAI service next

def get_tts_service(openai_service_instance: OpenAIService = None) -> BaseTTSService:
    provider = os.getenv("TTS_PROVIDER", "openai").lower()
    print(f"TTS Provider selected: '{provider}'")

    if provider == "custom":
        return CustomTTSService()
    elif provider == "openai":
        # If an instance was passed in, reuse it. Otherwise, create a new one.
        return openai_service_instance if openai_service_instance else OpenAIService()
    else:
        raise ValueError(f"Unknown TTS provider specified: {provider}. Use 'openai' or 'custom'.")