custom_fixes = {
    "تكيف": "تَكَيُّف",
    "بقاء": "بَقَّااء",
    "قدرة": "قُدرَة",
    "نقل": "نَقْل",
    "دب": "دُبّ",
    "نمر": "نَمِر",
    "فرو": "فَروُ",
    "بني": "بُنّي",
    "ملونة": "مِلوِنَةْ",
    "قوس قزح": "قُوس قُزَح",
    "معينة": "مُعيَّنَة",
    "فنك": "فنِك",
    "حر": "حَر",
    "شم": "شَمْ",
    "بصر": "بَصَر",
    "أذن": "اُذُن",
    "فم": "فَم",
    "عين": "عِين",
    "لهث": "لَّهْث",
    "قطط": "قطط",
    "لنقل": "لنَقْل",
    "قدم": "قَدَمْ",
    "مية": "مَيَّةْ",
    "حاسة": "حاسة",
    "دهون": "دُهون",
}

import re

def apply_fixes(text, fixes_dict):
    for wrong, fixed in fixes_dict.items():
        pattern = rf"\b(ال|يت|مت)?{wrong}(ات|ها|هم|ه|ي|ون|ين)?\b"
        
        def replacer(m):
            prefix = m.group(1) or ""
            suffix = m.group(2) or ""
            return prefix + fixed + suffix
        
        text = re.sub(pattern, replacer, text)
    return text
