from pydantic import BaseModel

class TTSConfig(BaseModel):
    """Holds configuration for a single TTS model."""
    language: str
    model_name_or_path: str
    speaker_directory: str
    config_path: str | None = None
    vocab_path: str | None = None


ARABIC_MODEL_CONFIG = TTSConfig(
    language="ar",
    model_name_or_path="./model/EGTTS-V0.1/",
    speaker_directory="anan",
    config_path="./model/EGTTS-V0.1/config.json",
    vocab_path="./model/EGTTS-V0.1/vocab.json"
)

ENGLISH_MODEL_CONFIG = TTSConfig(
    language="en",
    model_name_or_path="./model_en/",
    speaker_directory="anan",
    config_path="./model_en/config.json",
    vocab_path="./model_en/vocab.json"
)


SUPPORTED_MODELS = {
    "ar": ARABIC_MODEL_CONFIG,
    "en": ENGLISH_MODEL_CONFIG,
}

inference_config = {
    "temperature": 0.1,
    "length_penalty": 0.9,
    "repetition_penalty": 1.2,
    "enable_text_splitting": True,
}
