from fastapi import APIRouter, UploadFile, File, Form, BackgroundTasks
from fastapi.responses import FileResponse
from fastapi import HTTPException
import os
from pathlib import Path
import sys
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))
from process_pdf_pipline import process_pdf_curriculum_in_background

router = APIRouter(tags=["Curriculum"])

    


@router.post("/process-curriculum", status_code=202)
async def process_curriculum_webhook(
    background_tasks: BackgroundTasks,
    grade: int = Form(...), 
    subject: str = Form(...),
    file: UploadFile = File(...)
                                ):
    """
    Accepts a PDF and adds a background task to process it.
    Returns immediately.
    """
    pdf_bytes = await file.read()
    

    background_tasks.add_task(
        process_pdf_curriculum_in_background, 
        pdf_bytes, 
        file.filename,
        grade,
        subject
    )
    
    # Return immediately to the user
    return {"status": "processing_started", "message": "The curriculum is being processed in the background."}
